/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.effectsizes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.RemoveEffectsizeValueFromOutcomebranchAA;
import metaanalysis.actions.models.SetEffectsizeValueToOutcomebranchAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.effectsize.valuesdefinition.ESVFlavor;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.guiandnodes.effectsizes.editors.EffectSizeEditorMainPanel;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class EffectsizebranchNode
extends AbstractApplicationNode {
    private IEffectSizeValue effectsizevalue;
    private Outcomebranch outcomebranch;

    public EffectsizebranchNode(Outcomebranch outcomebranch, IEffectSizeValue effectsizevalue, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)effectsizevalue));
        this.outcomebranch = outcomebranch;
        this.effectsizevalue = effectsizevalue;
        this.setDisplayName("Effect size");
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/effect_size_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/effect_size_iconOpen.png");
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveEffectsizeValueFromOutcomebranchAA(this.outcomebranch, this.applicationEventWorker));
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RemoveAction()};
    }

    public PasteType getDropType(final Transferable t, int arg1, int arg2) {
        if (t.isDataFlavorSupported(ESVFlavor.ESV_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        IEffectSizeValue es = (IEffectSizeValue)t.getTransferData(ESVFlavor.ESV_FLAVOR);
                        EffectsizebranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new SetEffectsizeValueToOutcomebranchAA(es, EffectsizebranchNode.this.outcomebranch, EffectsizebranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType p = this.getDropType(t, 0, 0);
        if (p != null) {
            s.add(p);
        }
    }

    public EffectSizeEditorMainPanel getNodeEditor() {
        return new EffectSizeEditorMainPanel(this.outcomebranch.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    private class RemoveAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveAction() {
            this.putValue("Name", NbBundle.getMessage(EffectsizebranchNode.class, (String)"EffectsizebranchNode.RemoveESAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EffectsizebranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveEffectsizeValueFromOutcomebranchAA(EffectsizebranchNode.this.outcomebranch, EffectsizebranchNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }
}

