/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.effectsizes.editors;

import formattazione.numeri.MyNumberFormatter;
import javax.swing.JComboBox;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.dataeditor.models.AbstractDataEditorSubPanel;
import metaanalysis.effectsizes.models.IEffectSizeValue;

public abstract class AbstractEffectSizeEditorPanel
extends AbstractDataEditorSubPanel {
    protected IEffectSizeValue effectSizeValue = null;
    protected Outcomebranch outcomebranch;
    protected Outcome outcome;
    protected MyNumberFormatter myNumberFormatter;

    public AbstractEffectSizeEditorPanel(IEffectSizeValue effectSizeValue, Outcomebranch outcomebranch, IApplicationManager applicationEventWorker) {
        this.myNumberFormatter = applicationEventWorker.getMyNumberFormatter();
        this.effectSizeValue = effectSizeValue;
        this.outcomebranch = outcomebranch;
        this.outcome = this.getIApplicationManager().getIDataFunction().getOutcome(outcomebranch.getOutcomeId().intValue());
        this.setBackground(StyleProvider.panelBackground);
    }

    public Outcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(Outcome outcome) {
        this.outcome = outcome;
    }

    public IEffectSizeValue getEffectSizeValue() {
        return this.effectSizeValue;
    }

    public void setEffectSizeValue(IEffectSizeValue effectSizeValue) {
        this.effectSizeValue = effectSizeValue;
    }

    public Outcomebranch getOutcomebranch() {
        return this.outcomebranch;
    }

    public void setOutcomebranch(Outcomebranch outcomebranch) {
        this.outcomebranch = outcomebranch;
    }

    public static void fillEffectDirectionCombo(JComboBox combo) {
        combo.removeAllItems();
        combo.addItem(IEffectSizeValue.effectDirectionAutoLabel);
        combo.addItem(IEffectSizeValue.effectDirectionPositiveLabel);
        combo.addItem(IEffectSizeValue.effectDirectionNegativeLabel);
    }

    public static void fillRestrictedEffectDirectionCombo(JComboBox combo) {
        combo.removeAllItems();
        combo.addItem(IEffectSizeValue.effectDirectionPositiveLabel);
        combo.addItem(IEffectSizeValue.effectDirectionNegativeLabel);
    }

    public static void fillRestrictedEffectDirectionCombo(JComboBox combo, int initValue) {
        AbstractEffectSizeEditorPanel.fillRestrictedEffectDirectionCombo(combo);
        AbstractEffectSizeEditorPanel.setEffectDirectionComboSelectedItem(combo, initValue);
    }

    public static void fillEffectDirectionCombo(JComboBox combo, int initValue) {
        AbstractEffectSizeEditorPanel.fillEffectDirectionCombo(combo);
        AbstractEffectSizeEditorPanel.setEffectDirectionComboSelectedItem(combo, initValue);
    }

    public static int readEffectDirectionCombo(JComboBox combo) {
        if (combo.getSelectedItem().toString().equals(IEffectSizeValue.effectDirectionAutoLabel)) {
            return 1;
        }
        if (combo.getSelectedItem().toString().equals(IEffectSizeValue.effectDirectionPositiveLabel)) {
            return 2;
        }
        if (combo.getSelectedItem().toString().equals(IEffectSizeValue.effectDirectionNegativeLabel)) {
            return 3;
        }
        return 1;
    }

    public static void setEffectDirectionComboSelectedItem(JComboBox combo, int effectDirection) {
        if (effectDirection == 1) {
            combo.setSelectedItem(IEffectSizeValue.effectDirectionAutoLabel);
        } else if (effectDirection == 2) {
            combo.setSelectedItem(IEffectSizeValue.effectDirectionPositiveLabel);
        } else if (effectDirection == 3) {
            combo.setSelectedItem(IEffectSizeValue.effectDirectionNegativeLabel);
        }
    }

    public static void fillTailsCombo(JComboBox combo) {
        combo.removeAllItems();
        combo.addItem(IEffectSizeValue.twoTailsLabel);
        combo.addItem(IEffectSizeValue.oneTailLabel);
    }

    public static void fillTailsCombo(JComboBox combo, int initValue) {
        AbstractEffectSizeEditorPanel.fillTailsCombo(combo);
        AbstractEffectSizeEditorPanel.setTailsComboSelectedItem(combo, initValue);
    }

    public static void setTailsComboSelectedItem(JComboBox combo, int tails) {
        if (tails == 1) {
            combo.setSelectedItem(IEffectSizeValue.oneTailLabel);
        } else {
            combo.setSelectedItem(IEffectSizeValue.twoTailsLabel);
        }
    }

    public static int readTailsCombo(JComboBox combo) {
        if (combo.getSelectedItem().toString().equals(IEffectSizeValue.oneTailLabel)) {
            return 1;
        }
        return 2;
    }
}

