/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.effectsizes.editors;

import formattazione.numeri.MyNumberFormatter;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalysis.analysis.models.AnalysisFilter;
import metaanalysis.application.style.LabelsProvider;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.effectsizes.models.IEffectSizeResults;
import org.openide.util.NbBundle;

public class EffectSizeViewer
extends JPanel {
    private final MyNumberFormatter myNumberFormatter;
    private JTextField effectSizeField;
    private JLabel esLabel;
    private JLabel llLabel;
    private JTextField lowerLimitField;
    private JTextField pValueField;
    private JLabel pvalueLabel;
    private JLabel seLabel;
    private JTextField standardErrorField;
    private JLabel ulLabel;
    private JTextField upperLimitField;
    private JTextField varianceField;
    private JLabel varianceLabel;

    public EffectSizeViewer(MyNumberFormatter myNumberFormatter) {
        this.initComponents();
        this.setBackground(StyleProvider.panelBackground);
        this.esLabel.setText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.effectSize"));
        this.llLabel.setText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.extended.lowerLimit"));
        this.ulLabel.setText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.extended.upperLimit"));
        this.pvalueLabel.setText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.pvalue"));
        this.varianceLabel.setText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.variance"));
        this.seLabel.setText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.labels.standarderror"));
        this.esLabel.setToolTipText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.effectSize"));
        this.llLabel.setToolTipText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.lowerLimit"));
        this.ulLabel.setToolTipText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.upperLimit"));
        this.pvalueLabel.setToolTipText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.pvalue"));
        this.varianceLabel.setToolTipText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.variance"));
        this.seLabel.setToolTipText(NbBundle.getMessage(LabelsProvider.class, (String)"headers.tooltype.standarderror"));
        this.myNumberFormatter = myNumberFormatter;
    }

    public void clear() {
        this.effectSizeField.setText("");
        this.lowerLimitField.setText("");
        this.upperLimitField.setText("");
        this.pValueField.setText("");
        this.varianceField.setText("");
        this.standardErrorField.setText("");
        this.effectSizeField.setToolTipText("");
        this.lowerLimitField.setToolTipText("");
        this.upperLimitField.setToolTipText("");
        this.pValueField.setToolTipText("");
        this.varianceField.setToolTipText("");
        this.standardErrorField.setToolTipText("");
    }

    public void showEffectSize(IEffectSizeResults es, String pressEffectSize) {
        String findCalculationEffectSizeType = AnalysisFilter.findCalculationEffectSizeType((String)pressEffectSize);
        if (es == null) {
            this.clear();
        } else {
            if (es.getEffectSize() != null) {
                this.effectSizeField.setText(this.myNumberFormatter.formatDouble(es.getEffectSize(), 2));
                this.effectSizeField.setToolTipText(this.myNumberFormatter.formatInLang(es.getEffectSize().doubleValue()));
            } else {
                this.effectSizeField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculated"));
                this.effectSizeField.setToolTipText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculatedTooltype"));
            }
            if (es.getLowerLimit() != null) {
                this.lowerLimitField.setText(this.myNumberFormatter.formatDouble(es.getLowerLimit(), 2));
                this.lowerLimitField.setToolTipText(this.myNumberFormatter.formatInLang(es.getLowerLimit().doubleValue()));
            } else {
                this.lowerLimitField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculated"));
                this.lowerLimitField.setToolTipText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculatedTooltype"));
            }
            if (es.getUpperLimit() != null) {
                this.upperLimitField.setText(this.myNumberFormatter.formatDouble(es.getUpperLimit(), 2));
                this.upperLimitField.setToolTipText(this.myNumberFormatter.formatInLang(es.getUpperLimit().doubleValue()));
            } else {
                this.upperLimitField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculated"));
                this.upperLimitField.setToolTipText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculatedTooltype"));
            }
            if (es.getPValue() != null) {
                this.pValueField.setText(this.myNumberFormatter.formatDouble(es.getPValue(), 3));
                this.pValueField.setToolTipText(this.myNumberFormatter.formatInLang(es.getPValue().doubleValue()));
            } else {
                this.pValueField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculated"));
                this.pValueField.setToolTipText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculatedTooltype"));
            }
            if (es.getVariance() != null) {
                this.varianceField.setText(this.myNumberFormatter.formatDouble(es.getVariance(), 2));
                this.varianceField.setToolTipText(this.myNumberFormatter.formatInLang(es.getVariance().doubleValue()));
            } else {
                this.varianceField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculated"));
                this.varianceField.setToolTipText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.vaiavedere") + findCalculationEffectSizeType);
            }
            if (es.getStandardError() != null) {
                this.standardErrorField.setText(this.myNumberFormatter.formatDouble(es.getStandardError(), 2));
                this.standardErrorField.setToolTipText(this.myNumberFormatter.formatInLang(es.getStandardError().doubleValue()));
            } else {
                this.standardErrorField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.notCalculated"));
                this.standardErrorField.setToolTipText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.vaiavedere") + findCalculationEffectSizeType);
            }
        }
    }

    private void initComponents() {
        this.esLabel = new JLabel();
        this.effectSizeField = new JTextField();
        this.llLabel = new JLabel();
        this.lowerLimitField = new JTextField();
        this.ulLabel = new JLabel();
        this.upperLimitField = new JTextField();
        this.pvalueLabel = new JLabel();
        this.pValueField = new JTextField();
        this.varianceLabel = new JLabel();
        this.varianceField = new JTextField();
        this.seLabel = new JLabel();
        this.standardErrorField = new JTextField();
        this.esLabel.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.esLabel.text"));
        this.effectSizeField.setEditable(false);
        this.effectSizeField.setHorizontalAlignment(4);
        this.effectSizeField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.effectSizeField.text"));
        this.effectSizeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                EffectSizeViewer.this.effectSizeFieldFocusGained(evt);
            }
        });
        this.llLabel.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.llLabel.text"));
        this.lowerLimitField.setEditable(false);
        this.lowerLimitField.setHorizontalAlignment(4);
        this.lowerLimitField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.lowerLimitField.text"));
        this.lowerLimitField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                EffectSizeViewer.this.lowerLimitFieldFocusGained(evt);
            }
        });
        this.ulLabel.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.ulLabel.text"));
        this.upperLimitField.setEditable(false);
        this.upperLimitField.setHorizontalAlignment(4);
        this.upperLimitField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.upperLimitField.text"));
        this.upperLimitField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                EffectSizeViewer.this.upperLimitFieldFocusGained(evt);
            }
        });
        this.pvalueLabel.setText("sig.");
        this.pvalueLabel.setToolTipText("");
        this.pValueField.setEditable(false);
        this.pValueField.setHorizontalAlignment(4);
        this.pValueField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.pValueField.text"));
        this.pValueField.setToolTipText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.pValueField.toolTipText"));
        this.pValueField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                EffectSizeViewer.this.pValueFieldFocusGained(evt);
            }
        });
        this.varianceLabel.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.varianceLabel.text"));
        this.varianceField.setEditable(false);
        this.varianceField.setHorizontalAlignment(4);
        this.varianceField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.varianceField.text"));
        this.varianceField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                EffectSizeViewer.this.varianceFieldFocusGained(evt);
            }
        });
        this.seLabel.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.seLabel.text"));
        this.standardErrorField.setEditable(false);
        this.standardErrorField.setHorizontalAlignment(4);
        this.standardErrorField.setText(NbBundle.getMessage(EffectSizeViewer.class, (String)"EffectSizeViewer.standardErrorField.text"));
        this.standardErrorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                EffectSizeViewer.this.standardErrorFieldFocusGained(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.esLabel, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.effectSizeField, -2, 68, -2)).addGroup(layout.createSequentialGroup().addComponent(this.llLabel, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lowerLimitField, -2, 68, -2)).addGroup(layout.createSequentialGroup().addComponent(this.ulLabel, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upperLimitField, -2, 68, -2)).addGroup(layout.createSequentialGroup().addComponent(this.pvalueLabel, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pValueField, -2, 68, -2)).addGroup(layout.createSequentialGroup().addComponent(this.varianceLabel, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.varianceField, -2, 68, -2)).addGroup(layout.createSequentialGroup().addComponent(this.seLabel, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.standardErrorField, -2, 68, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.esLabel).addComponent(this.effectSizeField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.llLabel).addComponent(this.lowerLimitField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ulLabel).addComponent(this.upperLimitField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pvalueLabel).addComponent(this.pValueField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.varianceLabel).addComponent(this.varianceField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.seLabel).addComponent(this.standardErrorField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void effectSizeFieldFocusGained(FocusEvent evt) {
        if (TuliTuliTools.isAutoSelectContentFieldEnabled()) {
            this.effectSizeField.selectAll();
        }
    }

    private void lowerLimitFieldFocusGained(FocusEvent evt) {
        if (TuliTuliTools.isAutoSelectContentFieldEnabled()) {
            this.lowerLimitField.selectAll();
        }
    }

    private void upperLimitFieldFocusGained(FocusEvent evt) {
        if (TuliTuliTools.isAutoSelectContentFieldEnabled()) {
            this.upperLimitField.selectAll();
        }
    }

    private void pValueFieldFocusGained(FocusEvent evt) {
        if (TuliTuliTools.isAutoSelectContentFieldEnabled()) {
            this.pValueField.selectAll();
        }
    }

    private void varianceFieldFocusGained(FocusEvent evt) {
        if (TuliTuliTools.isAutoSelectContentFieldEnabled()) {
            this.varianceField.selectAll();
        }
    }

    private void standardErrorFieldFocusGained(FocusEvent evt) {
        if (TuliTuliTools.isAutoSelectContentFieldEnabled()) {
            this.standardErrorField.selectAll();
        }
    }
}

