/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.plugin.functionsimplementationstandard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import metaanalysis.core.functionsapi.DatabaseTreeNullException;
import metaanalysis.core.functionsapi.IDataFunctions;
import metaanalysis.core.hibernatelib.SessionHandler;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Longidgen;
import metaanalysis.core.persistence.Moderator;
import metaanalysis.core.persistence.Moderatorlevel;
import metaanalysis.core.persistence.ModeratorlevelId;
import metaanalysis.core.persistence.Moderatorrecode;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.ModeratorvalueId;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Preanalysis;
import metaanalysis.core.persistence.Project;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.core.persistence.Topic;
import metaanalysis.core.tools.DatabaseRowCompleteName;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class StandardFunctions
implements IDataFunctions {
    public List<Topic> getAllTopics() {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createCriteria(Topic.class).list();
        t.commit();
        return list;
    }

    public List<Topic> getAllOpenedTopics() {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Topic as topic where topic.status = ?").setString(0, Topic.openedTopic).list();
        t.commit();
        return list;
    }

    public void openOneTopic(Topic t) {
        for (Topic tmp : this.getAllTopics()) {
            if (tmp.getId() == t.getId()) {
                tmp.setStatus(Topic.openedTopic);
                this.saveOrUpdateObject(tmp);
                continue;
            }
            if (tmp.getStatus() != null && !tmp.getStatus().equals(Topic.openedTopic)) continue;
            tmp.setStatus(Topic.closedTopic);
            this.saveOrUpdateObject(tmp);
        }
    }

    public List<Study> getAllStudiesOfTopic(Topic topic) {
        return this.getAllStudiesOfTopic(topic.getId());
    }

    public List<Study> getAllStudiesOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Study as study where study.topicId = ? order by study.name").setLong(0, topicId).list();
        t.commit();
        return list;
    }

    public List<Subgroup> getAllSubgroupsOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Subgroup as subgroup where subgroup.topicId = ? order by subgroup.name").setLong(0, topicId).list();
        t.commit();
        return list;
    }

    public List<Subgroup> getAllSubgroupsOfTopic(Topic topic) {
        return this.getAllSubgroupsOfTopic(topic.getId());
    }

    public List<Comparison> getAllComparisonsOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Comparison as comparison where comparison.topicId = ?").setLong(0, topicId).list();
        t.commit();
        return list;
    }

    public List<Comparison> getAllComparisonsOfTopic(Topic topic) {
        return this.getAllComparisonsOfTopic(topic.getId());
    }

    public List<Outcome> getAllOutcomesOfTopic(Topic topic) {
        return this.getAllOutcomesOfTopic(topic.getId());
    }

    public List<Outcome> getAllOutcomesOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Outcome as outcome where outcome.topicId = ?").setLong(0, topicId).list();
        t.commit();
        return list;
    }

    public List<Moderator> getAllModeratorsOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Moderator as moderator where moderator.topicId = ? order by moderator.name").setLong(0, topicId).list();
        t.commit();
        return list;
    }

    public List<Moderator> getAllModeratorsOfTopic(Topic topic) {
        return this.getAllModeratorsOfTopic(topic.getId());
    }

    public List<Subgroupbranch> getAllSubgroupbranchesOfStudy(Study study) {
        return this.getAllSubgroupbranchesOfStudy(study.getId());
    }

    public List<Subgroupbranch> getAllSubgroupbranchesOfStudy(long studyId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select subgroupbranch from Subgroupbranch as subgroupbranch, Subgroup as subgroup where subgroupbranch.studyId = ? and subgroup.id=subgroupbranch.subgroupId order by subgroup.name").setLong(0, studyId).list();
        t.commit();
        return list;
    }

    public List<Comparisonbranch> getAllComparisonbranchesOfSubgroupbranch(Subgroupbranch subgroupbranch) {
        return this.getAllComparisonbranchesOfSubgroupbranch(subgroupbranch.getId());
    }

    public List<Comparisonbranch> getAllComparisonbranchesOfSubgroupbranch(long subgroupbranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select comparisonbranch from Comparisonbranch as comparisonbranch, Comparison as comparison where comparisonbranch.subgroupbranchId = ? and comparison.id=comparisonbranch.comparisonId order by comparison.name").setLong(0, subgroupbranchId).list();
        t.commit();
        return list;
    }

    public List<Comparisonbranch> getAllComparisonbranchesOfStudy(long studyId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select comparisonbranch from Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch where comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId = ?").setLong(0, studyId).list();
        t.commit();
        return list;
    }

    public List<Comparisonbranch> getAllComparisonbranchesOfStudy(Study study) {
        return this.getAllComparisonbranchesOfStudy(study.getId());
    }

    public List<Timepointbranch> getAllTimepointbranchesOfComparisonbranch(Comparisonbranch comparisonbranch) {
        return this.getAllTimepointbranchesOfComparisonbranch(comparisonbranch.getId());
    }

    public List<Timepointbranch> getAllTimepointbranchesOfComparisonbranch(long comparisonbranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Timepointbranch as timepointbranch where timepointbranch.comparisonbranchId = ? order by timepointId").setLong(0, comparisonbranchId).list();
        t.commit();
        return list;
    }

    public List<Timepointbranch> getAllTimepointbranchesOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select timepointbranch from Timepointbranch timepointbranch, Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch, Study as study where timepointbranch.comparisonbranchId=comparisonbranch.id and comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId = study.id and study.topicId=?").setLong(0, topicId).list();
        t.commit();
        return list;
    }

    public List<Timepointbranch> getAllTimepointbranchesOfTopic(long topicId, int timepointNumber) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select timepointbranch from Timepointbranch timepointbranch, Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch, Study as study where timepointbranch.comparisonbranchId=comparisonbranch.id and comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId = study.id and study.topicId=? and timepointbranch.timepointId=?").setLong(0, topicId).setInteger(1, timepointNumber).list();
        t.commit();
        return list;
    }

    public List<Timepointbranch> getAllTimepointbranchesOfStudy(long studyId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select timepointbranch from Timepointbranch as timepointbranch, Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch where timepointbranch.comparisonbranchId=comparisonbranch.id and comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId =?").setLong(0, studyId).list();
        t.commit();
        return list;
    }

    public List<Timepointbranch> getAllTimepointbranchesOfStudy(Study study) {
        return this.getAllTimepointbranchesOfStudy(study.getId());
    }

    public List<Outcomebranch> getAllOutcomebranchsOfTimepointbranch(Timepointbranch timepointbranch) {
        return this.getAllOutcomebranchsOfTimepointbranch(timepointbranch.getId());
    }

    public List<Outcomebranch> getAllOutcomebranchsOfTimepointbranch(long timepointbranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select outcomebranch from Outcomebranch as outcomebranch, Outcome as outcome where outcomebranch.timepointbranchId = ? and outcomebranch.outcomeId = outcome.id order by outcome.name").setLong(0, timepointbranchId).list();
        t.commit();
        return list;
    }

    public List<Outcomebranch> getAllOutcomebranchsOfTopic(Topic topic) {
        return this.getAllOutcomebranchsOfTopic(topic.getId());
    }

    public List<Outcomebranch> getAllOutcomebranchsOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select outcomebranch from Outcomebranch outcomebranch, Timepointbranch as timepointbranch, Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch, Study as study where outcomebranch.timepointbranchId=timepointbranch.id and timepointbranch.comparisonbranchId=comparisonbranch.id and comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId = study.id and study.topicId=?").setLong(0, topicId).list();
        t.commit();
        return list;
    }

    public List<Outcomebranch> getAllOutcomebranchsOfStudy(long studyId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select outcomebranch from Outcomebranch outcomebranch, Timepointbranch as timepointbranch, Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch where outcomebranch.timepointbranchId=timepointbranch.id and timepointbranch.comparisonbranchId=comparisonbranch.id and comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId =?").setLong(0, studyId).list();
        t.commit();
        return list;
    }

    public List<Outcomebranch> getAllOutcomebranchsOfSubgroupbranch(long subgroupbranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select outcomebranch from Outcomebranch outcomebranch, Timepointbranch as timepointbranch, Comparisonbranch as comparisonbranch where outcomebranch.timepointbranchId=timepointbranch.id and timepointbranch.comparisonbranchId=comparisonbranch.id and comparisonbranch.subgroupbranchId =?").setLong(0, subgroupbranchId).list();
        t.commit();
        return list;
    }

    public List<Outcomebranch> getAllOutcomebranchsOfComparisonbranch(long comparisonbranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select outcomebranch from Outcomebranch outcomebranch, Timepointbranch as timepointbranch where outcomebranch.timepointbranchId=timepointbranch.id and timepointbranch.comparisonbranchId =?").setLong(0, comparisonbranchId).list();
        t.commit();
        return list;
    }

    public int getMaxTimepointOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List x = s.createQuery("select max(timepointbranch.timepointId) from Timepointbranch as timepointbranch, Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch, Study as study where timepointbranch.comparisonbranchId=comparisonbranch.id and comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId = study.id and study.topicId=?").setLong(0, topicId).list();
        t.commit();
        if (x == null || x.isEmpty()) {
            return 0;
        }
        if (x.get(0) == null) {
            return 0;
        }
        return (Integer)x.get(0);
    }

    public List<Outcomebranch> getAllOutcomebranchsOfOutcome(Outcome outcome) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Outcomebranch as outcomebranch where outcomebranch.outcomeId = ?").setInteger(0, outcome.getId()).list();
        t.commit();
        return list;
    }

    public List<Comparisonbranch> getAllComparisonbranchsOfComparison(Comparison comparison) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Comparisonbranch as comparisonbranch where comparisonbranch.comparisonId = ?").setInteger(0, comparison.getId()).list();
        t.commit();
        return list;
    }

    public List<Subgroupbranch> getAllSubgroupbranchesOfSubgroup(Subgroup subgroup) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Subgroupbranch as subgroupbranch where subgroupbranch.subgroupId = ?").setInteger(0, subgroup.getId()).list();
        t.commit();
        return list;
    }

    public List<Moderatorvalue> getAllModeratorValuesOfNode(long longidgenId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select moderatorvalue from Moderatorvalue as moderatorvalue, Moderator as moderator where moderatorvalue.id.longidgenId = ? and moderatorvalue.id.moderatorId = moderator.id order by moderator.name").setLong(0, longidgenId).list();
        t.commit();
        return list;
    }

    public List<Moderatorvalue> getAllModeratorValuesOfOutcomebranch(long outcomebranchId) {
        ArrayList<Moderatorvalue> mvl = new ArrayList<Moderatorvalue>();
        Study s = this.getStudyOfOutcomebranch(outcomebranchId);
        List<Moderatorlevel> allModeratorLevelsOfStudy = this.getAllModeratorLevelsOfStudy(s.getId());
        for (Moderatorlevel ml : allModeratorLevelsOfStudy) {
            if (ml.getModeratorlevel() == Moderatorlevel.outcomebranchLevel) {
                mvl.add(this.getModeratorvalue(new ModeratorvalueId(ml.getId().getModeratorId(), s.getId(), outcomebranchId)));
                continue;
            }
            if (ml.getModeratorlevel() != Moderatorlevel.studyLevel) continue;
            mvl.add(this.getModeratorvalue(new ModeratorvalueId(ml.getId().getModeratorId(), s.getId(), s.getId())));
        }
        return mvl;
    }

    public List<Moderatorlevel> getAllModeratorLevelsOfModerator(int moderatorId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Moderatorlevel as moderatorlevel where moderatorlevel.id.moderatorId = ?").setInteger(0, moderatorId).list();
        t.commit();
        return list;
    }

    public List<Moderatorlevel> getAllModeratorLevelsOfStudy(long studyId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Moderatorlevel as moderatorlevel where moderatorlevel.id.studyId = ?").setLong(0, studyId).list();
        t.commit();
        return list;
    }

    public Study getStudyOfOutcomebranch(long outcomebranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select study from Study study, Outcomebranch as outcomebranch, Timepointbranch as timepointbranch, Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch where outcomebranch.timepointbranchId=timepointbranch.id and timepointbranch.comparisonbranchId=comparisonbranch.id and comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId=study.id and outcomebranch.id = ?").setLong(0, outcomebranchId).list();
        t.commit();
        if (list.isEmpty()) {
            return null;
        }
        return (Study)list.get(0);
    }

    public Study getStudyOfTimepointbranch(long timepointbranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select study from Study study, Timepointbranch as timepointbranch, Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch where timepointbranch.comparisonbranchId=comparisonbranch.id and comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId=study.id and timepointbranch.id = ?").setLong(0, timepointbranchId).list();
        t.commit();
        if (list.isEmpty()) {
            return null;
        }
        return (Study)list.get(0);
    }

    public Study getStudyOfComparisonbranch(long comparisonbranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("select study from Study study, Comparisonbranch as comparisonbranch, Subgroupbranch as subgroupbranch where comparisonbranch.subgroupbranchId=subgroupbranch.id and subgroupbranch.studyId=study.id and comparisonbranch.id = ?").setLong(0, comparisonbranchId).list();
        t.commit();
        if (list.isEmpty()) {
            return null;
        }
        return (Study)list.get(0);
    }

    public List<Moderatorvalue> getAllModeratorValuesOfStudy(long studyid) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Moderatorvalue as moderatorvalue where moderatorvalue.id.studyId =  ?").setLong(0, studyid).list();
        t.commit();
        return list;
    }

    public List<Moderatorvalue> getAllModeratorValuesOfStudy(long studyid, int moderatorId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Moderatorvalue as moderatorvalue where moderatorvalue.id.studyId =  ? and moderatorvalue.id.moderatorId =  ?").setLong(0, studyid).setInteger(1, moderatorId).list();
        t.commit();
        return list;
    }

    public List<Moderatorvalue> getAllModeratorValuesOfModerator(int moderatorId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Moderatorvalue as moderatorvalue where moderatorvalue.id.moderatorId = ?").setInteger(0, moderatorId).list();
        t.commit();
        return list;
    }

    public List<Moderatorvalue> getAllModeratorValuesOfModerator(Moderator moderator) {
        return this.getAllModeratorValuesOfModerator(moderator.getId());
    }

    public List<Moderatorrecode> getAllModeratorrecodeOfModerator(int moderatorId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Moderatorrecode as moderatorrecode where moderatorrecode.moderatorId = ?").setInteger(0, moderatorId).list();
        t.commit();
        return list;
    }

    public List<Moderatorrecode> getAllModeratorrecodeOfModerator(Moderator moderator) {
        return this.getAllModeratorrecodeOfModerator(moderator.getId());
    }

    public List<Project> getAllProjectsOfTopic(Topic topic) {
        return this.getAllProjectsOfTopic(topic.getId());
    }

    public List<Project> getAllProjectsOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Project as project where project.topicId = ?").setLong(0, topicId).list();
        t.commit();
        return list;
    }

    public List<Preanalysis> getAllPreanalysisOfTopic(Topic topic) {
        return this.getAllPreanalysisOfTopic(topic.getId());
    }

    public List<Preanalysis> getAllPreanalysisOfTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Preanalysis as preanalysis where preanalysis.topicId = ?").setLong(0, topicId).list();
        t.commit();
        return list;
    }

    public void updateComparison(Comparison comparison) {
        this.saveOrUpdateObject(comparison);
    }

    public void updateOutcome(Outcome outcome) {
        this.saveOrUpdateObject(outcome);
    }

    public void updateModerator(Moderator moderator) {
        this.saveOrUpdateObject(moderator);
    }

    public void updateModeratorlevel(Moderatorlevel moderatorlevel) {
        this.saveOrUpdateObject(moderatorlevel);
    }

    public void updateModeratorvalue(Moderatorvalue moderatorvalue) {
        this.saveOrUpdateObject(moderatorvalue);
    }

    public void updateTopic(Topic topic) {
        this.saveOrUpdateObject(topic);
    }

    public void updateSubgroup(Subgroup subgroup) {
        this.saveOrUpdateObject(subgroup);
    }

    public void updateStudy(Study study) {
        this.saveOrUpdateObject(study);
    }

    public void updateOutcomebranch(Outcomebranch outcomebranch) {
        this.saveOrUpdateObject(outcomebranch);
    }

    public void updateComparisonbranch(Comparisonbranch comparisonbranch) {
        this.saveOrUpdateObject(comparisonbranch);
    }

    public void updateSubgroupbranch(Subgroupbranch subgroupbranch) {
        this.saveOrUpdateObject(subgroupbranch);
    }

    public void updateModeratorrecode(Moderatorrecode moderatorrecode) {
        this.saveOrUpdateObject(moderatorrecode);
    }

    public void updateProject(Project project) {
        this.saveOrUpdateObject(project);
    }

    public void updatePreanalysis(Preanalysis preanalysis) {
        this.saveOrUpdateObject(preanalysis);
    }

    public long createTopic(Topic topic) {
        topic.setId(new Date().getTime());
        this.saveOrUpdateObject(topic);
        return topic.getId();
    }

    public long createTopic(Topic topic, long forcedId) {
        topic.setId(forcedId);
        this.saveOrUpdateObject(topic);
        return topic.getId();
    }

    public long createStudy(Study study) {
        Long id = this.getStudyNextId();
        study.setId(id.longValue());
        this.saveOrUpdateObject(study);
        return id.intValue();
    }

    public int createSubgroup(Subgroup subgroup) {
        Integer id = this.getSubgroupNextId();
        subgroup.setId(id.intValue());
        this.saveOrUpdateObject(subgroup);
        return id;
    }

    public int createComparison(Comparison comparison) {
        Integer id = this.getComparisonNextId();
        comparison.setId(id.intValue());
        this.saveOrUpdateObject(comparison);
        return id;
    }

    public int createOutcome(Outcome outcome) {
        Integer id = this.getOutcomeNextId();
        outcome.setId(id.intValue());
        this.saveOrUpdateObject(outcome);
        return id;
    }

    public int createModerator(Moderator moderator) {
        Integer id = this.getModeratorNextId();
        moderator.setId(id.intValue());
        this.saveOrUpdateObject(moderator);
        return id;
    }

    public long createOutcomebranch(Outcomebranch outcomebranch) {
        Long id = this.getOutcomebranchNextId();
        outcomebranch.setId(id.longValue());
        this.saveOrUpdateObject(outcomebranch);
        return id;
    }

    public long createTimepointbranch(Timepointbranch timepointbranch) {
        Long id = this.getTimepointbranchNextId();
        timepointbranch.setId(id.longValue());
        this.saveOrUpdateObject(timepointbranch);
        return id;
    }

    public long createComparisonbranch(Comparisonbranch comparisonbranch) {
        Long id = this.getComparisonbranchNextId();
        comparisonbranch.setId(id.longValue());
        this.saveOrUpdateObject(comparisonbranch);
        return id;
    }

    public long createSubgroupbranch(Subgroupbranch subgroupbranch) {
        Long id = this.getSubgroupbranchNextId();
        subgroupbranch.setId(id.longValue());
        this.saveOrUpdateObject(subgroupbranch);
        return id;
    }

    public long createModeratorrecode(Moderatorrecode moderatorrecode) {
        long id = this.getModeratorrecodeNextId();
        moderatorrecode.setId(id);
        this.saveOrUpdateObject(moderatorrecode);
        return id;
    }

    public int createProject(Project project) {
        Integer id = this.getProjectNextId();
        project.setId(id.intValue());
        this.saveOrUpdateObject(project);
        return id;
    }

    public int createPreanalysis(Preanalysis preanalysis) {
        Integer id = this.getPreanalysisNextId();
        preanalysis.setId(id.intValue());
        this.saveOrUpdateObject(preanalysis);
        return id;
    }

    public void saveStudy(Study study) {
        this.saveOrUpdateObject(study);
    }

    public void saveSubgroup(Subgroup subgroup) {
        this.saveOrUpdateObject(subgroup);
    }

    public void saveComparison(Comparison comparison) {
        this.saveOrUpdateObject(comparison);
    }

    public void saveOutcome(Outcome outcome) {
        this.saveOrUpdateObject(outcome);
    }

    public void saveModerator(Moderator moderator) {
        this.saveOrUpdateObject(moderator);
    }

    public void saveModeratorlevel(Moderatorlevel moderatorlevel) {
        this.saveOrUpdateObject(moderatorlevel);
    }

    public void saveSubgroupBranch(Subgroupbranch subgroupbranch) {
        this.saveOrUpdateObject(subgroupbranch);
    }

    public void saveComparisonBranch(Comparisonbranch comparisonbranch) {
        this.saveOrUpdateObject(comparisonbranch);
    }

    public void saveModeratorvalue(Moderatorvalue moderatorvalue) {
        this.saveOrUpdateObject(moderatorvalue);
    }

    public void saveOutcomebranch(Outcomebranch outcomebranch) {
        this.saveOrUpdateObject(outcomebranch);
    }

    public void saveTimepointbranch(Timepointbranch timepointbranch) {
        this.saveOrUpdateObject(timepointbranch);
    }

    public void saveComparisonbranch(Comparisonbranch comparisonbranch) {
        this.saveOrUpdateObject(comparisonbranch);
    }

    public void saveSubgroupbranch(Subgroupbranch subgroupbranch) {
        this.saveOrUpdateObject(subgroupbranch);
    }

    public void saveModeratorrecode(Moderatorrecode moderatorrecode) {
        this.saveOrUpdateObject(moderatorrecode);
    }

    public void saveProject(Project project) {
        this.saveOrUpdateObject(project);
    }

    public void savePreanalysis(Preanalysis preanalysis) {
        this.saveOrUpdateObject(preanalysis);
    }

    public Subgroupbranch linkSubgroupToStudy(Subgroup subgroup, Study study) {
        Subgroupbranch sgb = new Subgroupbranch();
        sgb.setStudyId(Long.valueOf(study.getId()));
        sgb.setSubgroupId(Integer.valueOf(subgroup.getId()));
        sgb.setId(this.getSubgroupbranchNextId());
        this.saveSubgroupBranch(sgb);
        return sgb;
    }

    public Comparisonbranch linkComparisonToSubgroupbranch(Comparison comparison, Subgroupbranch subgroupbranch) {
        Comparisonbranch tmp = new Comparisonbranch();
        tmp.setComparisonId(Integer.valueOf(comparison.getId()));
        tmp.setSubgroupbranchId(Long.valueOf(subgroupbranch.getId()));
        tmp.setId(this.getComparisonbranchNextId());
        this.saveComparisonBranch(tmp);
        return tmp;
    }

    public void removeTopic(Topic topic) {
        this.deleteObject(topic);
    }

    public void removeStudy(Study study) {
        this.deleteObject(study);
    }

    public void removeSubgroup(Subgroup subgroup) {
        this.deleteObject(subgroup);
    }

    public void removeComparison(Comparison comparison) {
        this.deleteObject(comparison);
    }

    public void removeOutcome(Outcome outcome) {
        this.deleteObject(outcome);
    }

    public void removeModerator(Moderator moderator) {
        this.deleteObject(moderator);
    }

    public void removeModeratorlevel(Moderatorlevel moderatorlevel) {
        this.deleteObject(moderatorlevel);
    }

    public void removeOutcomebranch(Outcomebranch outcomebranch) {
        this.deleteObject(outcomebranch);
    }

    public void removeTimepointbranch(Timepointbranch timepointbranch) {
        this.deleteObject(timepointbranch);
    }

    public void removeComparisonbranch(Comparisonbranch comparisonbranch) {
        this.deleteObject(comparisonbranch);
    }

    public void removeSubgroupbranch(Subgroupbranch subgroupbranch) {
        this.deleteObject(subgroupbranch);
    }

    public void removeModeratorValue(Moderatorvalue moderatorvalue) {
        this.deleteObject(moderatorvalue);
    }

    public void removeModeratorrecode(Moderatorrecode moderatorrecode) {
        this.deleteObject(moderatorrecode);
    }

    public void removeProject(Project project) {
        this.deleteObject(project);
    }

    public void removePreanalysis(Preanalysis preanalysis) {
        this.deleteObject(preanalysis);
    }

    public Topic getTopic(long topicId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Topic tmp = (Topic)s.get(Topic.class, (Serializable)new Long(topicId));
        t.commit();
        return tmp;
    }

    public Study getStudy(long studyId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Study tmp = (Study)s.get(Study.class, (Serializable)new Long(studyId));
        t.commit();
        return tmp;
    }

    public Subgroup getSubgroup(int subgroupId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Subgroup tmp = (Subgroup)s.get(Subgroup.class, (Serializable)new Integer(subgroupId));
        t.commit();
        return tmp;
    }

    public Subgroup getDefaultSubgroup() {
        return this.getSubgroup(-1);
    }

    public Comparison getComparison(int comparisonId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Comparison tmp = (Comparison)s.get(Comparison.class, (Serializable)new Integer(comparisonId));
        t.commit();
        return tmp;
    }

    public Comparison getDefaultComparison() {
        return this.getComparison(-1);
    }

    public Outcome getOutcome(int outcomeId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Outcome tmp = (Outcome)s.get(Outcome.class, (Serializable)new Integer(outcomeId));
        t.commit();
        return tmp;
    }

    public Moderator getModerator(int moderatorId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Moderator tmp = (Moderator)s.get(Moderator.class, (Serializable)new Integer(moderatorId));
        t.commit();
        return tmp;
    }

    public Moderatorrecode getModeratorrecode(long moderatorrecodeId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Moderatorrecode tmp = (Moderatorrecode)s.get(Moderatorrecode.class, (Serializable)new Long(moderatorrecodeId));
        t.commit();
        return tmp;
    }

    public Outcomebranch getOutcomebranch(long id) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Outcomebranch tmp = (Outcomebranch)s.get(Outcomebranch.class, (Serializable)new Long(id));
        t.commit();
        return tmp;
    }

    public Timepointbranch getTimepointbranch(long id) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Timepointbranch tmp = (Timepointbranch)s.get(Timepointbranch.class, (Serializable)new Long(id));
        t.commit();
        return tmp;
    }

    public Comparisonbranch getComparisonbranch(long id) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Comparisonbranch tmp = (Comparisonbranch)s.get(Comparisonbranch.class, (Serializable)new Long(id));
        t.commit();
        return tmp;
    }

    public Subgroupbranch getSubgroupbranch(long id) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Subgroupbranch tmp = (Subgroupbranch)s.get(Subgroupbranch.class, (Serializable)new Long(id));
        t.commit();
        return tmp;
    }

    public Moderatorvalue getModeratorvalue(ModeratorvalueId moderatorvalueId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Moderatorvalue tmp = (Moderatorvalue)s.get(Moderatorvalue.class, (Serializable)moderatorvalueId);
        t.commit();
        return tmp;
    }

    public Moderatorlevel getModeratorlevel(ModeratorlevelId moderatorlevelId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Moderatorlevel tmp = (Moderatorlevel)s.get(Moderatorlevel.class, (Serializable)moderatorlevelId);
        t.commit();
        return tmp;
    }

    public Project getProject(int projectId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Project tmp = (Project)s.get(Project.class, (Serializable)new Integer(projectId));
        t.commit();
        return tmp;
    }

    public Preanalysis getPreanalysis(int preanalysisId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Preanalysis tmp = (Preanalysis)s.get(Preanalysis.class, (Serializable)new Integer(preanalysisId));
        t.commit();
        return tmp;
    }

    public static void updateMe(Object obj) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        s.update(obj);
        t.commit();
    }

    private int getSubgroupNextId() {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List x = s.createQuery("select max(subgroup.id) from Subgroup as subgroup").list();
        t.commit();
        if (x == null || x.isEmpty()) {
            return 1;
        }
        if (x.get(0) == null) {
            return 1;
        }
        return (Integer)x.get(0) + 1;
    }

    private long getStudyNextId() {
        return this.getNextLongId();
    }

    private int getProjectNextId() {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List x = s.createQuery("select max(project.id) from Project as project").list();
        t.commit();
        if (x == null || x.isEmpty()) {
            return 1;
        }
        if (x.get(0) == null) {
            return 1;
        }
        return (Integer)x.get(0) + 1;
    }

    private int getPreanalysisNextId() {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List x = s.createQuery("select max(preanalysis.id) from Preanalysis as preanalysis").list();
        t.commit();
        if (x == null || x.isEmpty()) {
            return 1;
        }
        if (x.get(0) == null) {
            return 1;
        }
        return (Integer)x.get(0) + 1;
    }

    private int getComparisonNextId() {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List x = s.createQuery("select max(comparison.id) from Comparison as comparison").list();
        t.commit();
        if (x == null || x.isEmpty()) {
            return 1;
        }
        if (x.get(0) == null) {
            return 1;
        }
        return (Integer)x.get(0) + 1;
    }

    private int getOutcomeNextId() {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List x = s.createQuery("select max(outcome.id) from Outcome as outcome").list();
        t.commit();
        if (x == null || x.isEmpty()) {
            return 1;
        }
        if (x.get(0) == null) {
            return 1;
        }
        return (Integer)x.get(0) + 1;
    }

    private int getModeratorNextId() {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List x = s.createQuery("select max(moderator.id) from Moderator as moderator").list();
        t.commit();
        if (x == null || x.isEmpty()) {
            return 1;
        }
        if (x.get(0) == null) {
            return 1;
        }
        return (Integer)x.get(0) + 1;
    }

    private long getModeratorrecodeNextId() {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List x = s.createQuery("select max(moderatorrecode.id) from Moderatorrecode as moderatorrecode").list();
        t.commit();
        if (x == null || x.isEmpty()) {
            return 1L;
        }
        if (x.get(0) == null) {
            return 1L;
        }
        return (Long)x.get(0) + 1L;
    }

    private long getSubgroupbranchNextId() {
        return this.getNextLongId();
    }

    private long getComparisonbranchNextId() {
        return this.getNextLongId();
    }

    private long getOutcomebranchNextId() {
        return this.getNextLongId();
    }

    private long getTimepointbranchNextId() {
        return this.getNextLongId();
    }

    private long getNextLongId() {
        Longidgen tmp = new Longidgen();
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        Long id = (Long)s.save((Object)tmp);
        t.commit();
        return id;
    }

    private void saveOrUpdateObject(Object obj) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        s.saveOrUpdate(obj);
        t.commit();
    }

    private void deleteObject(Object obj) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        s.delete(obj);
        t.commit();
    }

    public boolean outcomebranchExist(Outcome outcome, Timepointbranch timepointbranch) {
        return this.outcomebranchExist(outcome.getId(), timepointbranch.getId());
    }

    public boolean outcomebranchExist(int outcomeId, long timepointbranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Outcomebranch as outcomebranch where outcomebranch.outcomeId = ? and outcomebranch.timepointbranchId = ?").setInteger(0, outcomeId).setLong(1, timepointbranchId).list();
        t.commit();
        return list.size() > 0;
    }

    public boolean comparisonbranchExist(Comparison comparison, Subgroupbranch subgroupbranch) {
        return this.comparisonbranchExist(comparison.getId(), subgroupbranch.getId());
    }

    public boolean comparisonbranchExist(int comparisonId, long subgroupbranchId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Comparisonbranch as comparisonbranch where comparisonbranch.comparisonId = ? and comparisonbranch.subgroupbranchId = ?").setInteger(0, comparisonId).setLong(1, subgroupbranchId).list();
        t.commit();
        return list.size() > 0;
    }

    public boolean subgroupbranchExist(Subgroup subgroup, Study study) {
        return this.comparisonbranchExist(subgroup.getId(), study.getId());
    }

    public boolean subgroupbranchExist(int subgroupId, long studyId) {
        Session s = SessionHandler.currentSession();
        Transaction t = s.beginTransaction();
        List list = s.createQuery("from Subgroupbranch as subgroupbranch where subgroupbranch.subgroupId = ? and subgroupbranch.studyId = ?").setInteger(0, subgroupId).setLong(1, studyId).list();
        t.commit();
        return list.size() > 0;
    }

    public Moderator getSystemModerator(long topidId, String systemLevel) {
        List<Moderator> allModeratorsOfTopic = this.getAllModeratorsOfTopic(topidId);
        for (Moderator m : allModeratorsOfTopic) {
            if (!m.getSystemlevel().equals(systemLevel)) continue;
            return m;
        }
        return null;
    }

    public DatabaseRowCompleteName getOutcomebranchCompleteName(long outcomebranchId) throws DatabaseTreeNullException {
        return this.getOutcomebranchCompleteName(this.getOutcomebranch(outcomebranchId));
    }

    public DatabaseRowCompleteName getOutcomebranchCompleteName(Outcomebranch outcomebranch) {
        Subgroupbranch subgroupbranch;
        Comparisonbranch comparisonbranch;
        String subgroupName = null;
        String comparisonName = null;
        String timepointName = null;
        Timepointbranch timepointbranch = this.getTimepointbranch(outcomebranch.getTimepointbranchId());
        List<Timepointbranch> allTimepointbranchesOfComparisonbranch = this.getAllTimepointbranchesOfComparisonbranch(timepointbranch.getComparisonbranchId());
        if (allTimepointbranchesOfComparisonbranch.size() > 1) {
            timepointName = "W" + (timepointbranch.getTimepointId() + 1);
        }
        if ((comparisonbranch = this.getComparisonbranch(timepointbranch.getComparisonbranchId())).getComparisonId() != -1) {
            comparisonName = this.getComparison(comparisonbranch.getComparisonId()).getName();
        }
        if ((subgroupbranch = this.getSubgroupbranch(comparisonbranch.getSubgroupbranchId())).getSubgroupId() != -1) {
            subgroupName = this.getSubgroup(subgroupbranch.getSubgroupId()).getName();
        }
        String studyName = this.getStudy(subgroupbranch.getStudyId()).getName();
        String outcomeName = this.getOutcome(outcomebranch.getOutcomeId()).getName();
        return new DatabaseRowCompleteName(studyName, subgroupName, comparisonName, timepointName, outcomeName);
    }

    public DatabaseRowCompleteName getTimepointbranchCompleteName(long timepointbranchId) throws DatabaseTreeNullException {
        Timepointbranch timepointbranch = this.getTimepointbranch(timepointbranchId);
        return this.getTimepointbranchCompleteName(timepointbranch);
    }

    public DatabaseRowCompleteName getTimepointbranchCompleteName(Timepointbranch timepointbranch) throws DatabaseTreeNullException {
        Subgroupbranch subgroupbranch;
        Comparisonbranch comparisonbranch;
        if (timepointbranch == null) {
            throw new DatabaseTreeNullException();
        }
        String subgroupName = null;
        String comparisonName = null;
        String timepointName = null;
        List<Timepointbranch> allTimepointbranchesOfComparisonbranch = this.getAllTimepointbranchesOfComparisonbranch(timepointbranch.getComparisonbranchId());
        if (allTimepointbranchesOfComparisonbranch.size() > 1) {
            timepointName = "W" + (timepointbranch.getTimepointId() + 1);
        }
        if ((comparisonbranch = this.getComparisonbranch(timepointbranch.getComparisonbranchId())).getComparisonId() != -1) {
            comparisonName = this.getComparison(comparisonbranch.getComparisonId()).getName();
        }
        if ((subgroupbranch = this.getSubgroupbranch(comparisonbranch.getSubgroupbranchId())).getSubgroupId() != -1) {
            subgroupName = this.getSubgroup(subgroupbranch.getSubgroupId()).getName();
        }
        String studyName = this.getStudy(subgroupbranch.getStudyId()).getName();
        return new DatabaseRowCompleteName(studyName, subgroupName, comparisonName, timepointName, null);
    }

    public DatabaseRowCompleteName getComparisonbranchCompleteName(long comparisonbranchId) throws DatabaseTreeNullException {
        return this.getComparisonbranchCompleteName(this.getComparisonbranch(comparisonbranchId));
    }

    public DatabaseRowCompleteName getComparisonbranchCompleteName(Comparisonbranch comparisonbranch) throws DatabaseTreeNullException {
        if (comparisonbranch == null) {
            throw new DatabaseTreeNullException();
        }
        String subgroupName = null;
        Subgroupbranch subgroupbranch = this.getSubgroupbranch(comparisonbranch.getSubgroupbranchId());
        if (subgroupbranch.getSubgroupId() != -1) {
            subgroupName = this.getSubgroup(subgroupbranch.getSubgroupId()).getName();
        }
        String studyName = this.getStudy(subgroupbranch.getStudyId()).getName();
        return new DatabaseRowCompleteName(studyName, subgroupName, this.getComparison(comparisonbranch.getComparisonId()).getName(), null, null);
    }

    public DatabaseRowCompleteName getSubgroupbranchCompleteName(long subgroupbranchId) throws DatabaseTreeNullException {
        return this.getSubgroupbranchCompleteName(this.getSubgroupbranch(subgroupbranchId));
    }

    public DatabaseRowCompleteName getSubgroupbranchCompleteName(Subgroupbranch subgroupbranch) throws DatabaseTreeNullException {
        if (subgroupbranch == null) {
            throw new DatabaseTreeNullException();
        }
        Object subgroupName = null;
        String studyName = this.getStudy(subgroupbranch.getStudyId()).getName();
        return new DatabaseRowCompleteName(studyName, this.getSubgroup(subgroupbranch.getSubgroupId()).getName(), null, null, null);
    }

    public Topic getFirstOpenedTopic() {
        List<Topic> allOpenedTopics = this.getAllOpenedTopics();
        if (allOpenedTopics.isEmpty()) {
            return null;
        }
        return allOpenedTopics.get(0);
    }
}

