/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.graph.funnelplot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import metaanalysis.graph.funnelplot.FunnelPlotGraphInput;
import metaanalysis.graph.funnelplot.FunnelPlotHandler;
import metaanalysis.graph.funnelplot.FunnelPlotRow;

public class FunnelPlotGraph
extends JPanel {
    private final FunnelPlotGraphInput graphInput;
    private final int altezza;
    private final int larghezza;
    private Locale locale;
    private boolean flagBlack;
    private final int raggioCerchio = 5;
    private final int altezzaRombo = 7;
    Font fontNormal;
    Font fontTitoli;
    String pattern2 = "#####0.00";
    String pattern3 = "#####0.000";
    FunnelPlotHandler funnelHandler;

    public FunnelPlotGraph(FunnelPlotGraphInput graphInput, int larghezza, int altezza, Locale locale, boolean flagBlack) {
        this.setBackground(Color.white);
        this.larghezza = larghezza;
        this.altezza = altezza;
        this.setSize(this.larghezza, this.altezza);
        this.fontNormal = new Font("Arial", 0, this.dimensionaFont());
        this.fontTitoli = new Font("Arial", 0, this.dimensionaFont() - 1);
        this.flagBlack = flagBlack;
        this.locale = locale;
        this.initComponents();
        this.graphInput = graphInput;
        this.funnelHandler = new FunnelPlotHandler(this.graphInput.getRows(), this.larghezza, this.altezza, this.flagBlack);
        this.disegnaStudi(this.funnelHandler);
    }

    private int dimensionaFont() {
        int dimensioneX = 14;
        int dimensioneY = 14;
        if (this.larghezza < 100) {
            dimensioneX = 8;
        }
        if (this.larghezza >= 100 && this.larghezza < 200) {
            dimensioneX = 9;
        }
        if (this.larghezza >= 200 && this.larghezza < 300) {
            dimensioneX = 10;
        }
        if (this.larghezza >= 300 && this.larghezza < 400) {
            dimensioneX = 11;
        }
        if (this.larghezza >= 400 && this.larghezza < 500) {
            dimensioneX = 12;
        }
        if (this.larghezza >= 500 && this.larghezza < 600) {
            dimensioneX = 13;
        }
        if (this.larghezza >= 600 && this.larghezza < 800) {
            dimensioneX = 14;
        }
        if (this.larghezza > 800) {
            dimensioneX = 15;
        }
        if (this.altezza < 100) {
            dimensioneY = 9;
        }
        if (this.altezza >= 100 && this.altezza < 200) {
            dimensioneY = 10;
        }
        if (this.altezza >= 200 && this.altezza < 300) {
            dimensioneY = 11;
        }
        if (this.altezza >= 300 && this.altezza < 400) {
            dimensioneY = 12;
        }
        if (this.altezza >= 400 && this.altezza < 500) {
            dimensioneY = 13;
        }
        if (this.altezza >= 500 && this.altezza < 600) {
            dimensioneY = 14;
        }
        if (this.altezza > 600) {
            dimensioneY = 15;
        }
        if (dimensioneX <= dimensioneY) {
            return dimensioneX;
        }
        return dimensioneY;
    }

    private void disegnaTitoli(FunnelPlotHandler funnelPlot) {
        JLabel xLabel = new JLabel("EFFECT SIZE");
        JLabel yLabel = new JLabel("STANDARD ERROR");
        xLabel.setFont(this.fontTitoli);
        yLabel.setFont(this.fontTitoli);
        xLabel.setHorizontalAlignment(0);
        xLabel.setBounds(funnelPlot.marginLeft + funnelPlot.titleLeft, this.altezza - funnelPlot.marginBottom - funnelPlot.titleBottom + 65, funnelPlot.larghezzaUtile, 20);
        if (this.larghezza < 250) {
            xLabel.setText("ES");
        } else {
            xLabel.setText("EFFECT SIZE");
        }
        yLabel.setVerticalAlignment(0);
        yLabel.setBounds(funnelPlot.marginLeft, funnelPlot.marginTop + funnelPlot.titleTop, funnelPlot.titleLeft, funnelPlot.altezzaUtile);
        if (this.altezza < 340) {
            yLabel.setText("<HTML>S<br>E</HTML>");
        } else {
            yLabel.setText("<HTML>S<br>T<br>A<br>N<br>D<br>A<br>R<br>D<br><br>E<br>R<br>R<br>O<br>R</HTML>");
        }
        this.add(xLabel);
        this.add(yLabel);
    }

    private void disegnaRettangolo(FunnelPlotHandler funnelPlot, Graphics g) {
        g.drawRect(funnelPlot.marginLeft + funnelPlot.titleLeft, funnelPlot.marginTop + funnelPlot.titleTop, funnelPlot.larghezzaUtile, funnelPlot.altezzaUtile);
    }

    private void disegnaStudi(FunnelPlotHandler funnelPlot) {
        NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
        DecimalFormat formatoT = (DecimalFormat)nf;
        formatoT.applyPattern(this.pattern2);
        for (int i = 0; i < this.graphInput.getRows().size(); ++i) {
            JLabel cerchio;
            if (this.graphInput.getRows().get(i).getType() == FunnelPlotRow.studyType) {
                cerchio = new JLabel("");
                cerchio.setIcon(new ImageIcon(this.getClass().getResource("/metaanalysis/graph/funnelplot/cerchio_bianco.png")));
                cerchio.setBounds(funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize()) - 5, funnelPlot.calcolaCoordinataY(this.graphInput.getRows().get(i).getStandardError()) - 5, 10, 10);
                cerchio.setVerticalAlignment(1);
                cerchio.setToolTipText("" + this.graphInput.getRows().get(i).getName() + "  ES " + formatoT.format(this.graphInput.getRows().get(i).getEffectSize()) + "  SE " + formatoT.format(this.graphInput.getRows().get(i).getStandardError()));
                this.add(cerchio);
            }
            if (!this.flagBlack || this.graphInput.getRows().get(i).getType() != FunnelPlotRow.studyBlackType) continue;
            cerchio = new JLabel("");
            cerchio.setIcon(new ImageIcon(this.getClass().getResource("/metaanalysis/graph/funnelplot/cerchio_nero.png")));
            cerchio.setHorizontalAlignment(0);
            int larghezzaLabel = (int)(funnelPlot.getStepScalaX() * funnelPlot.getxFP());
            cerchio.setBounds(funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize()) - 5, funnelPlot.calcolaCoordinataY(this.graphInput.getRows().get(i).getStandardError()) - 5, 10, 10);
            cerchio.setToolTipText("" + this.graphInput.getRows().get(i).getName() + "  ES " + formatoT.format(this.graphInput.getRows().get(i).getEffectSize()) + "  SE " + formatoT.format(this.graphInput.getRows().get(i).getStandardError()));
            this.add(cerchio);
        }
    }

    public void disegnaOverall(FunnelPlotHandler funnelPlot, Graphics g) {
        NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
        DecimalFormat formatoO = (DecimalFormat)nf;
        formatoO.applyPattern(this.pattern2);
        for (int i = 0; i < this.graphInput.getRows().size(); ++i) {
            if (this.graphInput.getRows().get(i).getType() == FunnelPlotRow.overallType | this.graphInput.getRows().get(i).getType() == FunnelPlotRow.overallBlackType && this.flagBlack & this.graphInput.getRows().get(i).getType() == FunnelPlotRow.overallBlackType | !this.flagBlack & this.graphInput.getRows().get(i).getType() == FunnelPlotRow.overallType) {
                JLabel lineaOverall = new JLabel(" ");
                lineaOverall.setIcon(new ImageIcon(this.getClass().getResource("/metaanalysis/graph/funnelplot/cerchio_nero.png")));
                lineaOverall.setHorizontalAlignment(0);
                int larghezzaLabel = (int)(funnelPlot.getStepScalaX() * funnelPlot.getxFP());
                lineaOverall.setBounds(funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize()), funnelPlot.calcolaCoordinataY(0.0), 1, funnelPlot.altezzaUtile);
                lineaOverall.setToolTipText("" + this.graphInput.getRows().get(i).getName() + "  ES " + formatoO.format(this.graphInput.getRows().get(i).getEffectSize()) + "  SE " + formatoO.format(this.graphInput.getRows().get(i).getStandardError()));
                lineaOverall.setOpaque(true);
                lineaOverall.setBackground(Color.black);
                this.add(lineaOverall);
                g.drawLine(funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize()), funnelPlot.calcolaCoordinataY(0.0), funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize() - 1.96 * funnelPlot.getsERange()), funnelPlot.calcolaCoordinataY(funnelPlot.getsERange()));
                g.drawLine(funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize()), funnelPlot.calcolaCoordinataY(0.0), funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize() + 1.96 * funnelPlot.getsERange()), funnelPlot.calcolaCoordinataY(funnelPlot.getsERange()));
            }
            int npoints = 5;
            int[] xpoints = new int[]{funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize()), funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getLowerLimit()), funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize()), funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getUpperLimit()), funnelPlot.calcolaCoordinataX(this.graphInput.getRows().get(i).getEffectSize())};
            if (this.graphInput.getRows().get(i).getType() == FunnelPlotRow.overallType) {
                int[] ypoints = new int[]{funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 7, funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 14, funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 21, funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 14, funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 7};
                g.drawPolygon(xpoints, ypoints, 5);
            }
            if (!this.flagBlack || this.graphInput.getRows().get(i).getType() != FunnelPlotRow.overallBlackType) continue;
            int[] yBlackPoints = new int[]{funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 16 + 7, funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 16 + 14, funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 16 + 21, funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 16 + 14, funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 16 + 7};
            g.fillPolygon(xpoints, yBlackPoints, 5);
        }
    }

    private void disegnaScalaRif(FunnelPlotHandler funnelPlot, Graphics g) {
        int larghezzaLabel;
        JLabel refLabel;
        NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
        DecimalFormat formatoY = (DecimalFormat)nf;
        formatoY.applyPattern(this.pattern2);
        g.setFont(this.fontNormal);
        double tmpy = -funnelPlot.getStepScalaY();
        while (tmpy < funnelPlot.getsERange() - funnelPlot.getStepScalaY()) {
            g.drawLine(funnelPlot.marginLeft + funnelPlot.titleLeft - 3, funnelPlot.calcolaCoordinataY(tmpy += funnelPlot.getStepScalaY()), funnelPlot.marginLeft + funnelPlot.titleLeft + 3, funnelPlot.calcolaCoordinataY(tmpy));
            JLabel refLabel2 = new JLabel("" + formatoY.format(tmpy));
            refLabel2.setFont(this.fontNormal);
            refLabel2.setHorizontalAlignment(4);
            int larghezzaLabel2 = (int)(funnelPlot.getStepScalaY() * funnelPlot.getyFP());
            refLabel2.setBounds(0, funnelPlot.calcolaCoordinataY(tmpy) - 10, funnelPlot.marginLeft + funnelPlot.titleLeft - 10, 20);
            this.add(refLabel2);
        }
        double tmp = -funnelPlot.getStepScalaX();
        while (tmp < funnelPlot.getMaxESRange() - funnelPlot.getStepScalaX()) {
            if (!((tmp += funnelPlot.getStepScalaX()) > funnelPlot.getMinESRange())) continue;
            g.drawLine(funnelPlot.calcolaCoordinataX(tmp), funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile - 3, funnelPlot.calcolaCoordinataX(tmp), funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 3);
            DecimalFormat formatoX = (DecimalFormat)nf;
            formatoX.applyPattern(this.pattern2);
            refLabel = new JLabel("" + formatoX.format(tmp));
            refLabel.setFont(this.fontNormal);
            refLabel.setHorizontalAlignment(0);
            larghezzaLabel = (int)(funnelPlot.getStepScalaX() * funnelPlot.getxFP());
            refLabel.setBounds(funnelPlot.calcolaCoordinataX(tmp) - larghezzaLabel / 2, this.altezza - funnelPlot.marginBottom - funnelPlot.titleBottom + 40, larghezzaLabel, 20);
            this.add(refLabel);
        }
        tmp = 0.0;
        while (tmp > funnelPlot.getMinESRange() + funnelPlot.getStepScalaX()) {
            if (!((tmp -= funnelPlot.getStepScalaX()) < funnelPlot.getMaxESRange())) continue;
            g.drawLine(funnelPlot.calcolaCoordinataX(tmp), funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile - 3, funnelPlot.calcolaCoordinataX(tmp), funnelPlot.marginTop + funnelPlot.titleTop + funnelPlot.altezzaUtile + 3);
            DecimalFormat valore = (DecimalFormat)nf;
            valore.applyPattern(this.pattern2);
            refLabel = new JLabel("" + valore.format(tmp));
            refLabel.setFont(this.fontNormal);
            refLabel.setHorizontalAlignment(0);
            larghezzaLabel = (int)(funnelPlot.getStepScalaX() * funnelPlot.getxFP());
            refLabel.setBounds(funnelPlot.calcolaCoordinataX(tmp) - larghezzaLabel / 2, this.altezza - funnelPlot.marginBottom - funnelPlot.titleBottom + 40, larghezzaLabel, 20);
            this.add(refLabel);
        }
    }

    public void disegnaMargini(Graphics g) {
        g.setColor(Color.MAGENTA);
        g.drawLine(0, this.funnelHandler.marginTop, this.larghezza, this.funnelHandler.marginTop);
        g.drawLine(0, this.altezza - this.funnelHandler.marginBottom, this.larghezza, this.altezza - this.funnelHandler.marginBottom);
        g.drawLine(this.funnelHandler.marginLeft, 0, this.funnelHandler.marginLeft, this.altezza);
        g.drawLine(this.larghezza - this.funnelHandler.marginRight, 0, this.larghezza - this.funnelHandler.marginRight, this.altezza);
        g.setColor(Color.blue);
        g.drawLine(0, this.funnelHandler.marginTop + this.funnelHandler.titleTop, this.larghezza, this.funnelHandler.marginTop + this.funnelHandler.titleTop);
        g.drawLine(0, this.altezza - this.funnelHandler.marginBottom - this.funnelHandler.titleBottom, this.larghezza, this.altezza - this.funnelHandler.marginBottom - this.funnelHandler.titleBottom);
        g.drawLine(this.funnelHandler.marginLeft + this.funnelHandler.titleLeft, 0, this.funnelHandler.marginLeft + this.funnelHandler.titleLeft, this.altezza);
        g.drawLine(this.larghezza - this.funnelHandler.marginRight - this.funnelHandler.titleRight, 0, this.larghezza - this.funnelHandler.marginRight - this.funnelHandler.titleRight, this.altezza);
    }

    public boolean getFlagBlack() {
        return this.flagBlack;
    }

    public final void riempi() {
    }

    private void initComponents() {
        this.setLayout(null);
    }

    public boolean isFlagBlack() {
        return this.flagBlack;
    }

    public void setFlagBlack(boolean flagBlack) {
        this.flagBlack = flagBlack;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.disegnaRettangolo(this.funnelHandler, g);
        this.disegnaTitoli(this.funnelHandler);
        this.disegnaScalaRif(this.funnelHandler, g);
        this.disegnaOverall(this.funnelHandler, g);
    }
}

