/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.graph.funnelplot;

import java.util.List;
import metaanalysis.graph.funnelplot.FunnelPlotRow;

public class FunnelPlotHandler {
    protected List<FunnelPlotRow> rows;
    int larghezza;
    int altezza;
    int marginTop = 10;
    int marginBottom = 10;
    int marginLeft = 10;
    int marginRight = 10;
    int titleBottom = 105;
    int titleLeft = 70;
    int titleTop = 10;
    int titleRight = 0;
    private double minESRange;
    private double maxESRange;
    private double eSRange;
    private double sERange;
    private double xFP;
    private double yFP;
    private double fattoreMargineY = 1.2;
    private double stepScalaX;
    private double stepScalaY;
    private boolean flagBlack;
    private double[] stepArray = new double[]{1.0E-4, 2.0E-4, 3.0E-4, 4.0E-4, 5.0E-4, 6.0E-4, 7.0E-4, 8.0E-4, 9.0E-4, 0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.009, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0, 2000.0, 3000.0, 4000.0, 5000.0, 6000.0, 7000.0, 8000.0, 9000.0, 10000.0};
    int altezzaUtile;
    int larghezzaUtile;

    public FunnelPlotHandler(List<FunnelPlotRow> rows, int larghezza, int altezza, boolean flagBlack) {
        this.rows = rows;
        this.larghezza = larghezza;
        this.altezza = altezza;
        this.flagBlack = flagBlack;
        double yRangeMargin = this.getSEMax() / 10.0;
        this.sERange = this.getSEMax() + yRangeMargin;
        this.altezzaUtile = this.altezza - this.marginTop - this.marginBottom - this.titleTop - this.titleBottom;
        this.larghezzaUtile = this.larghezza - this.marginLeft - this.marginRight - this.titleLeft - this.titleRight;
        double xRangeMargin = (this.getPlotUpperLimit() - this.getPlotLowerLimit()) / 3.0;
        this.minESRange = this.getPlotLowerLimit() - xRangeMargin;
        this.maxESRange = this.getPlotUpperLimit() + xRangeMargin;
        this.eSRange = this.getPlotUpperLimit() - this.getPlotLowerLimit() + 2.0 * xRangeMargin;
        this.xFP = (double)this.larghezzaUtile / this.eSRange;
        this.yFP = (double)this.altezzaUtile / this.sERange;
        this.stepScalaX = this.stepScalaX();
        this.stepScalaY = this.stepScalaY();
    }

    public double getMaxES() {
        double maxES = -99999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (this.flagBlack) {
                if (!(this.rows.get(i).getEffectSize() > maxES)) continue;
                maxES = this.rows.get(i).getEffectSize();
                continue;
            }
            if (this.rows.get(i).getType() == FunnelPlotRow.studyBlackType || this.rows.get(i).getType() == FunnelPlotRow.overallBlackType || !(this.rows.get(i).getEffectSize() > maxES)) continue;
            maxES = this.rows.get(i).getEffectSize();
        }
        return maxES;
    }

    public double getMinES() {
        double minES = 99999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (this.flagBlack) {
                if (!(this.rows.get(i).getEffectSize() < minES)) continue;
                minES = this.rows.get(i).getEffectSize();
                continue;
            }
            if (this.rows.get(i).getType() == FunnelPlotRow.studyBlackType || this.rows.get(i).getType() == FunnelPlotRow.overallBlackType || !(this.rows.get(i).getEffectSize() < minES)) continue;
            minES = this.rows.get(i).getEffectSize();
        }
        return minES;
    }

    public final double getPlotUpperLimit() {
        double maxES = this.getMaxES();
        double sERange = this.getsERange();
        double esMaxTriangolo = -999999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            double tmp;
            double tmp2;
            if (!this.flagBlack && this.rows.get(i).getType() == FunnelPlotRow.overallType && (tmp2 = 1.96 * this.getsERange() + this.rows.get(i).getEffectSize()) > esMaxTriangolo) {
                esMaxTriangolo = tmp2;
            }
            if (!this.flagBlack) continue;
            double upperLimitOverallBianco = 0.0;
            for (int k = 0; k < this.rows.size(); ++k) {
                if (this.rows.get(i).getType() != FunnelPlotRow.overallType) continue;
                upperLimitOverallBianco = this.rows.get(i).getUpperLimit();
            }
            if (this.rows.get(i).getType() == FunnelPlotRow.overallBlackType && (tmp = 1.96 * this.getsERange() + this.rows.get(i).getEffectSize()) > esMaxTriangolo) {
                esMaxTriangolo = tmp;
            }
            if (!(esMaxTriangolo < upperLimitOverallBianco)) continue;
            esMaxTriangolo = upperLimitOverallBianco;
        }
        if (maxES > esMaxTriangolo) {
            return maxES;
        }
        return esMaxTriangolo;
    }

    public final double getPlotLowerLimit() {
        double minES = this.getMinES();
        double overallLimit = 9.9999999E7;
        for (int i = 0; i < this.rows.size(); ++i) {
            double tmp;
            double tmp2;
            if (!this.flagBlack && this.rows.get(i).getType() == FunnelPlotRow.overallType && (tmp2 = this.rows.get(i).getEffectSize() - 1.96 * this.getsERange()) < overallLimit) {
                overallLimit = tmp2;
            }
            if (!this.flagBlack) continue;
            double lowerLimitOverallBianco = 0.0;
            for (int k = 0; k < this.rows.size(); ++k) {
                if (this.rows.get(i).getType() != FunnelPlotRow.overallType) continue;
                lowerLimitOverallBianco = this.rows.get(i).getLowerLimit();
            }
            if (this.rows.get(i).getType() == FunnelPlotRow.overallBlackType && (tmp = this.rows.get(i).getEffectSize() - 1.96 * this.getsERange()) < overallLimit) {
                overallLimit = tmp;
            }
            if (!(overallLimit > lowerLimitOverallBianco)) continue;
            overallLimit = lowerLimitOverallBianco;
        }
        if (minES < overallLimit) {
            return minES;
        }
        return overallLimit;
    }

    private double getSEMax() {
        double maxSE = -999999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rows.get(i).getStandardError() > maxSE)) continue;
            maxSE = this.rows.get(i).getStandardError();
        }
        return maxSE;
    }

    private double getSEMin() {
        double minSE = 999999.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            if (!(this.rows.get(i).getStandardError() < minSE)) continue;
            minSE = this.rows.get(i).getStandardError();
        }
        return minSE;
    }

    public int calcolaCoordinataX(double xValue) {
        return this.marginLeft + this.titleLeft + (int)((xValue - this.minESRange) * this.xFP);
    }

    public int calcolaCoordinataY(double yValue) {
        return this.marginTop + this.titleTop + (int)(yValue * this.yFP);
    }

    public final double stepScalaX() {
        double nTacche = 0.0;
        double nTaccheVoluteX = 8.0;
        if (this.larghezza < 200) {
            nTaccheVoluteX = 3.0;
        }
        if (this.larghezza >= 200 && this.larghezza < 300) {
            nTaccheVoluteX = 4.0;
        }
        if (this.larghezza >= 300 && this.larghezza < 500) {
            nTaccheVoluteX = 5.0;
        }
        if (this.larghezza >= 500 && this.larghezza < 600) {
            nTaccheVoluteX = 6.0;
        }
        if (this.larghezza >= 600 && this.larghezza < 700) {
            nTaccheVoluteX = 7.0;
        }
        if (this.larghezza > 700) {
            nTaccheVoluteX = 8.0;
        }
        int count = 0;
        for (int i = 1; i < this.stepArray.length; ++i) {
            nTacche = this.eSRange / this.stepArray[i];
            if (!(nTacche < nTaccheVoluteX)) continue;
            count = i - 1;
            break;
        }
        return this.stepArray[count];
    }

    public final double stepScalaY() {
        double nTacche = 0.0;
        double nTaccheVoluteY = 5.0;
        int count = 0;
        for (int i = 1; i < this.stepArray.length; ++i) {
            nTacche = this.sERange / this.stepArray[i];
            if (!(nTacche < nTaccheVoluteY)) continue;
            count = i - 1;
            break;
        }
        return this.stepArray[count];
    }

    public double arrotonda(double numero, int nCifreDecimali) {
        return (double)Math.round(numero * Math.pow(10.0, nCifreDecimali)) / Math.pow(10.0, nCifreDecimali);
    }

    public double geteSRange() {
        return this.eSRange;
    }

    public double getMaxESRange() {
        return this.maxESRange;
    }

    public double getMinESRange() {
        return this.minESRange;
    }

    public double getsERange() {
        return this.sERange;
    }

    public double getStepScalaX() {
        return this.stepScalaX;
    }

    public double getStepScalaY() {
        return this.stepScalaY;
    }

    public double getxFP() {
        return this.xFP;
    }

    public double getyFP() {
        return this.yFP;
    }
}

