/*
 * Decompiled with CFR 0.152.
 */
package forestplot.api;

import forestplot.api.FisherGrid;
import forestplot.api.IGrid;
import forestplot.api.IScale;
import forestplot.api.LogScale;
import forestplot.api.NoGridLine;
import forestplot.api.OutOfRangeInputValueException;
import forestplot.api.PlotInputData;
import forestplot.api.ScaleDataInputErrorException;
import org.openide.util.NbBundle;

public class FisherScale
implements IScale {
    private final PlotInputData plotInputData;
    private FisherGrid grid;
    private double min;
    private double max;

    public FisherScale(PlotInputData plotInputData) throws ScaleDataInputErrorException {
        this.plotInputData = plotInputData;
        if (plotInputData.getMinValue() <= -1.0 || plotInputData.getMaxValue() >= 1.0) {
            throw new ScaleDataInputErrorException(NbBundle.getMessage(LogScale.class, (String)"scale.fisher.inputerror"));
        }
        this.grid = new FisherGrid(this.plotInputData.getMinValue(), this.plotInputData.getMaxValue(), 4);
        try {
            this.max = this.grid.getUpperLine() > this.plotInputData.getMaxValue() ? this.grid.getUpperLine() : this.plotInputData.getMaxValue();
            this.min = this.grid.getLowerLine() < this.plotInputData.getMinValue() ? this.grid.getLowerLine() : this.plotInputData.getMinValue();
        }
        catch (NoGridLine ex) {
            this.max = this.plotInputData.getMaxValue();
            this.min = this.plotInputData.getMinValue();
        }
        double max_min = Math.abs(this.max - this.min);
    }

    @Override
    public double fromPressToCalculation(double value) throws OutOfRangeInputValueException {
        if (value >= 1.0 || value <= -1.0) {
            throw new OutOfRangeInputValueException(NbBundle.getMessage(LogScale.class, (String)"scale.wronginputvalue.error", (Object)("" + value)));
        }
        return 0.5 * Math.log((1.0 + value) / (1.0 - value));
    }

    @Override
    public double fromCalculationToPress(double value) {
        return (Math.pow(Math.E, value * 2.0) - 1.0) / (Math.pow(Math.E, value * 2.0) + 1.0);
    }

    @Override
    public IGrid getGrid() {
        return this.grid;
    }

    @Override
    public double getMaxValueOfForestPlotGraph() {
        return this.max;
    }

    @Override
    public double getMinValueOfForestPlotGraph() {
        return this.min;
    }
}

