/*
 * Decompiled with CFR 0.152.
 */
package forestplot.api;

import forestplot.api.AbstractGrid;
import forestplot.api.BloccoDiRighe;
import forestplot.api.ConfidenceIntervalLine;
import forestplot.api.ForestJPanel;
import forestplot.api.IForestPlotRow;
import forestplot.api.IGeometra;
import forestplot.api.IGrid;
import forestplot.api.IScale;
import forestplot.api.OutOfRangeInputValueException;
import forestplot.api.OverallRow;
import forestplot.api.PlotInputData;
import forestplot.graph.objects.LineaGriglia;
import forestplot.graph.objects.LineaTratteggiata;
import forestplot.graph.objects.MyLabel;
import forestplot.graph.objects.Quadrato;
import forestplot.graph.objects.Rombo;
import forestplot.util.FromESToPixelConverter;
import forestplot.util.ImageUtils;
import forestplot.util.QuadratoLatoCalculator;
import formattazione.numeri.MyNumberFormatter;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class Forest {
    private final PlotInputData plotInputData;
    private final IScale scale;
    private final IGrid grid;
    private final IGeometra geometra;
    private int width;
    private final MyNumberFormatter myNumberFormatter;
    private Font font;
    private final Graphics g;
    private FontMetrics fontMetrics;
    private FromESToPixelConverter fromESToPixelConverter;
    private QuadratoLatoCalculator quadratoLatoCalculator;
    private Font calcolaFontPerForestPlot;
    private int decimaliInGriglia;
    private double coefficientePerRiduzioneQuadratoMinimo = 0.3;
    private double coefficientePerRiduzioneQuadratoMassimo = 0.8;
    private int margineDiSicurezzaPerVedereUnaLinea = 22;
    private int margineTraPlotENumeriGriglia = 15;
    private int paddingOrizzontaleInPx = 25;
    private ForestJPanel panel = new ForestJPanel();

    public Forest(PlotInputData plotInputData, IScale scale, IGeometra geometra, int width, MyNumberFormatter myNumberFormatter, Font font, Graphics g) throws OutOfRangeInputValueException {
        this.plotInputData = plotInputData;
        this.scale = scale;
        this.grid = scale.getGrid();
        this.geometra = geometra;
        this.width = width;
        this.myNumberFormatter = myNumberFormatter;
        this.font = font;
        this.g = g;
        this.fontMetrics = g.getFontMetrics(font);
        this.panel.setSize(width, geometra.getUsefullHeight());
        this.decimaliInGriglia = this.calcolaDecimaliInGriglia();
        this.fromESToPixelConverter = new FromESToPixelConverter(this.scale.fromPressToCalculation(scale.getMinValueOfForestPlotGraph()), this.scale.fromPressToCalculation(scale.getMaxValueOfForestPlotGraph()), this.width, this.paddingOrizzontaleInPx);
        this.quadratoLatoCalculator = new QuadratoLatoCalculator(this.plotInputData.getMaxWeightFromDataEntryRows(), geometra.getAltezzaRigaDataEntryPrecisa() * this.getCoefficienteRiduzioneQuadrato());
        this.calcolaFontPerForestPlot = this.calcolaFontPerForestPlot();
        int blocchi = 0;
        double distanzaCopertaDalleRighe = 0.0;
        for (BloccoDiRighe b : plotInputData.getBlocchiRighe()) {
            for (IForestPlotRow row : b) {
                this.disegnaIntervalloDiConfidenza(row, geometra.getAltezzaTitoliTesta() + blocchi * geometra.getAltezzaSeparatoreBlocchi() + (int)distanzaCopertaDalleRighe);
                if (row instanceof OverallRow) {
                    this.disegnaRombo(row, geometra.getAltezzaTitoliTesta() + blocchi * geometra.getAltezzaSeparatoreBlocchi() + (int)distanzaCopertaDalleRighe);
                    if (this.plotInputData.getVisualizerBean().isOverallLine()) {
                        this.disegnaRigaOverall(row);
                    }
                } else {
                    this.disegnaQuadrato(row, geometra.getAltezzaTitoliTesta() + blocchi * geometra.getAltezzaSeparatoreBlocchi() + (int)distanzaCopertaDalleRighe);
                }
                distanzaCopertaDalleRighe += geometra.getAltezzaRigaPrecisa(row);
            }
            ++blocchi;
        }
        if (this.plotInputData.getVisualizerBean().isGrid()) {
            this.disegnaGriglia();
        }
        if (this.plotInputData.getVisualizerBean().isZeroLine()) {
            this.disegnaZeroLine();
        }
    }

    private void disegnaRigaOverall(IForestPlotRow row) throws OutOfRangeInputValueException {
        this.disegnaLineaVerticale(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(row.getEffectSize())), this.geometra.getAltezzaTitoliTesta(), 1, this.geometra.getUsefullHeight() - this.geometra.getAltezzaTitoliCoda() - this.geometra.getAltezzaTitoliTesta(), this.myNumberFormatter.formatInLang(row.getEffectSize().doubleValue()), true);
    }

    private void disegnaZeroLine() throws OutOfRangeInputValueException {
        this.disegnaLineaVerticale(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(this.plotInputData.getZeroLineValue())), this.geometra.getAltezzaTitoliTesta(), 3, this.geometra.getUsefullHeight() - this.geometra.getAltezzaTitoliCoda() - this.geometra.getAltezzaTitoliTesta(), this.myNumberFormatter.formatInLang(this.plotInputData.getZeroLineValue()), false);
        String format = this.myNumberFormatter.formatDouble(Double.valueOf(this.plotInputData.getZeroLineValue()), this.decimaliInGriglia, true);
        if (format.equals("-0")) {
            format = "0";
        }
        MyLabel etichetta = new MyLabel(format);
        etichetta.setVerticalAlignment(1);
        etichetta.setFont(this.calcolaFontPerForestPlot);
        etichetta.setHorizontalAlignment(0);
        etichetta.setBounds(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(this.plotInputData.getZeroLineValue())) - 80, this.geometra.getUsefullHeight() - this.geometra.getAltezzaTitoliCoda() + this.margineTraPlotENumeriGriglia, 160, this.geometra.getAltezzaTitoliCoda() - this.margineTraPlotENumeriGriglia);
        this.panel.add(etichetta);
    }

    public void disegnaGriglia() throws OutOfRangeInputValueException {
        for (Double d : this.grid.getLines()) {
            if (this.plotInputData.getVisualizerBean().isZeroLine() && Math.abs(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(d)) - this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(this.plotInputData.getZeroLineValue()))) <= this.margineDiSicurezzaPerVedereUnaLinea) continue;
            String linesStyle = NbPreferences.root().get("grid_line_style", AbstractGrid.grid_style_lines_extended);
            if (AbstractGrid.grid_style_lines_short.equals(linesStyle)) {
                this.disegnaLineaVerticale(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(d)), this.geometra.getCentralHeight() + this.geometra.getAltezzaTitoliTesta() + 6, 1, 2, this.myNumberFormatter.formatInLang(d.doubleValue()), false);
            } else if (AbstractGrid.grid_style_lines_dotted.equals(linesStyle)) {
                this.disegnaLineaVerticale(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(d)), this.geometra.getAltezzaTitoliTesta(), 1, this.geometra.getUsefullHeight() - this.geometra.getAltezzaTitoliTesta() - this.geometra.getAltezzaTitoliCoda(), this.myNumberFormatter.formatInLang(d.doubleValue()), true);
            } else {
                this.disegnaLineaVerticale(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(d)), this.geometra.getAltezzaTitoliTesta(), 1, this.geometra.getUsefullHeight() - this.geometra.getAltezzaTitoliTesta() - this.geometra.getAltezzaTitoliCoda(), this.myNumberFormatter.formatInLang(d.doubleValue()), false);
            }
            String format = this.myNumberFormatter.formatDouble(d, this.decimaliInGriglia, true);
            if (format.equals("-0")) {
                format = "0";
            }
            MyLabel etichetta = new MyLabel(format);
            etichetta.setVerticalAlignment(1);
            etichetta.setFont(this.calcolaFontPerForestPlot);
            etichetta.setHorizontalAlignment(0);
            etichetta.setBounds(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(d)) - 80, this.geometra.getUsefullHeight() - this.geometra.getAltezzaTitoliCoda() + this.margineTraPlotENumeriGriglia, 160, this.geometra.getAltezzaTitoliCoda() - this.margineTraPlotENumeriGriglia);
            this.panel.add(etichetta);
        }
    }

    private void disegnaLineaVerticale(int x, int y, int spessore, int altezza, String tooltip, boolean tratteggio) {
        int spostamentoSinistra = spessore / 2;
        MyLabel xxx = tratteggio ? new LineaTratteggiata() : new LineaGriglia();
        xxx.setToolTipText(tooltip);
        xxx.setBounds(x - spostamentoSinistra, y, spessore, altezza);
        this.panel.add(xxx);
    }

    private Font calcolaFontPerForestPlot() {
        int size = this.width / 38;
        if (size < 9) {
            size = 9;
        }
        if (size > 15) {
            size = 15;
        }
        return new Font(this.font.getFamily(), 0, size);
    }

    public void disegnaIntervalloDiConfidenza(IForestPlotRow row, int distanzaVerticaleDiPartenza) throws OutOfRangeInputValueException {
        ConfidenceIntervalLine xxx = new ConfidenceIntervalLine();
        xxx.setToolTipText(row.getName() + ": CI " + this.myNumberFormatter.formatInLang(row.getLowerLimit().doubleValue()) + " - " + this.myNumberFormatter.formatInLang(row.getUpperLimit().doubleValue()));
        xxx.setBounds(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(row.getLowerLimit())), distanzaVerticaleDiPartenza + (int)(this.geometra.getAltezzaRigaPrecisa(row) / 2.0), this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(row.getUpperLimit())) - this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(row.getLowerLimit())), 1);
        this.panel.add(xxx);
    }

    public void disegnaQuadrato(IForestPlotRow row, int distanzaVerticaleDiPartenza) throws OutOfRangeInputValueException {
        Quadrato xxx = new Quadrato();
        xxx.setToolTipText(row.getName() + ": ES " + this.myNumberFormatter.formatInLang(row.getEffectSize().doubleValue()));
        double lato = this.quadratoLatoCalculator.getLato(row.getWeight());
        xxx.setBounds(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(row.getEffectSize())) - (int)(lato / 2.0), distanzaVerticaleDiPartenza + ((int)(this.geometra.getAltezzaRigaPrecisa(row) / 2.0) - (int)(lato / 2.0)), (int)lato, (int)lato);
        this.panel.add(xxx);
    }

    private BufferedImage getScaledImage(BufferedImage srcImg, int w, int h) {
        return ImageUtils.resizeImage(srcImg, 1, w, h);
    }

    public void disegnaRombo(IForestPlotRow row, int distanzaVerticaleDiPartenza) throws OutOfRangeInputValueException {
        int lato = (int)((double)this.geometra.getAltezzaRigaDataEntryIntera() * this.coefficientePerRiduzioneQuadratoMassimo);
        if (lato <= 0) {
            lato = 1;
        }
        BufferedImage buffered = (BufferedImage)ImageUtilities.loadImage((String)"forestplot/graph/objects/rombo.png");
        BufferedImage loadImage = this.getScaledImage(buffered, lato, lato);
        ImageIcon icon = new ImageIcon(loadImage);
        Rombo xxx = new Rombo();
        xxx.setIcon(icon);
        xxx.setToolTipText(row.getName() + ": ES " + this.myNumberFormatter.formatInLang(row.getEffectSize().doubleValue()));
        xxx.setBounds(this.fromESToPixelConverter.getPixel(this.scale.fromPressToCalculation(row.getEffectSize())) - lato / 2, distanzaVerticaleDiPartenza + ((int)(this.geometra.getAltezzaRigaPrecisa(row) / 2.0) - lato / 2), lato, lato);
        this.panel.add(xxx);
    }

    public int getWidth() {
        return this.width;
    }

    public ForestJPanel getPanel() {
        return this.panel;
    }

    public int getHeight() {
        return this.geometra.getUsefullHeight();
    }

    private double getCoefficienteRiduzioneQuadrato() {
        double coeff = this.coefficientePerRiduzioneQuadratoMinimo + (this.coefficientePerRiduzioneQuadratoMassimo - this.coefficientePerRiduzioneQuadratoMinimo) / 20.0 * (double)this.plotInputData.getAllRowsNumber();
        return coeff > this.coefficientePerRiduzioneQuadratoMassimo ? this.coefficientePerRiduzioneQuadratoMassimo : coeff;
    }

    private int calcolaDecimaliInGriglia() {
        double delta = Math.abs(this.plotInputData.getMaxValue() - this.plotInputData.getMinValue());
        if (delta < 1.0E-12) {
            return 14;
        }
        if (delta < 1.0E-11) {
            return 13;
        }
        if (delta < 1.0E-10) {
            return 12;
        }
        if (delta < 1.0E-9) {
            return 11;
        }
        if (delta < 1.0E-8) {
            return 10;
        }
        if (delta < 1.0E-7) {
            return 9;
        }
        if (delta < 1.0E-6) {
            return 8;
        }
        if (delta < 1.0E-5) {
            return 7;
        }
        if (delta < 1.0E-4) {
            return 6;
        }
        if (delta < 0.001) {
            return 5;
        }
        if (delta < 0.01) {
            return 4;
        }
        if (delta < 0.1) {
            return 3;
        }
        return 2;
    }
}

