/*
 * Decompiled with CFR 0.152.
 */
package forestplot.api;

import forestplot.api.Forest;
import forestplot.api.ForestJPanel;
import forestplot.api.ForestPlotException;
import forestplot.api.IScale;
import forestplot.api.PlotInputData;
import forestplot.frame.StandardGeometra;
import forestplot.graph.objects.MyJPanel;
import forestplot.tables.Tabella;
import forestplot.tables.TabellaJPanel;
import formattazione.numeri.MyNumberFormatter;
import java.awt.Font;
import java.awt.Graphics;

public class Grafico
extends MyJPanel {
    private final PlotInputData plotInputData;
    public static int distanzaTabellaVsGrafico = 20;
    public static double altezzaMassimaTesto = 0.7;
    public static double offsetDivisoreAltezzaTesto = 0.2;
    public static int numeroDiLineeInGriglia = 4;
    private final MyNumberFormatter myNumberFormatter;

    public Grafico(PlotInputData plotInputData, IScale scale, int width, int height, Graphics g, MyNumberFormatter myNumberFormatter) throws ForestPlotException {
        this.plotInputData = plotInputData;
        this.setLayout(null);
        this.setSize(width, height);
        this.myNumberFormatter = myNumberFormatter;
        StandardGeometra geometra = new StandardGeometra(width, height, plotInputData, 10, 10, 2, 10);
        Font font = new Font("arial", 0, (int)((double)geometra.getAltezzaRigaDataEntryIntera() * this.calcolaDivisorePerAltezzaFont()));
        Tabella tabella = new Tabella(this.plotInputData, geometra, font, g);
        TabellaJPanel tab = tabella.getPanel();
        tab.setBounds(geometra.getMargineSinistro(), geometra.getMargineHeader(), tabella.getWidth(), tabella.getHeight());
        Forest forest = new Forest(this.plotInputData, scale, geometra, width - geometra.getMargineSinistro() - tabella.getWidth() - distanzaTabellaVsGrafico - geometra.getMargineDestro(), myNumberFormatter, font, g);
        ForestJPanel graph = forest.getPanel();
        graph.setBounds(geometra.getMargineSinistro() + tabella.getWidth() + distanzaTabellaVsGrafico, geometra.getMargineHeader(), forest.getWidth(), forest.getHeight());
        this.add(tab);
        this.add(graph);
    }

    private double calcolaDivisorePerAltezzaFont() {
        double ret = (double)this.plotInputData.getBlocchiRighe().getRowsNumber() * 0.05 + offsetDivisoreAltezzaTesto;
        return ret > altezzaMassimaTesto ? altezzaMassimaTesto : ret;
    }
}

