/*
 * Decompiled with CFR 0.152.
 */
package forestplot.api;

import forestplot.api.AbstractGrid;
import forestplot.api.IGrid;
import forestplot.api.NoGridLine;
import java.util.ArrayList;
import java.util.List;

public class LinearGrid
extends AbstractGrid
implements IGrid {
    private ArrayList<Double> linee = new ArrayList();
    private double percentualeDiVicinanzaAmmissibileAllaZeroLine = 0.1;

    public LinearGrid(double esMinimo, double esMassimo, double zeroLineValue, int numeroMinimoDiLineeInterne, boolean lineeEsterne) {
        double volte;
        double esMin = esMinimo;
        double esMax = esMassimo;
        double range = esMax - esMin;
        double scala = 100000.0;
        for (int i = 0; !(i >= 1000 || (volte = range / (scala /= 2.0)) >= (double)numeroMinimoDiLineeInterne || (volte = range / (scala = scala * 2.0 / 5.0)) >= (double)numeroMinimoDiLineeInterne || (volte = range / (scala /= 2.0)) >= (double)numeroMinimoDiLineeInterne); ++i) {
        }
        double prima = zeroLineValue;
        if (zeroLineValue == 0.0 || zeroLineValue == 1.0) {
            if (scala > 0.9) {
                prima = 0.0;
            }
            while (prima > esMin) {
                prima -= scala;
            }
            if (!lineeEsterne) {
                prima += scala;
            }
            while (prima < esMax) {
                this.linee.add(prima);
                prima += scala;
            }
            if (lineeEsterne) {
                this.linee.add(prima);
            }
        } else {
            double minimo = zeroLineValue < esMin ? zeroLineValue : esMin;
            double massimo = zeroLineValue > esMax ? zeroLineValue : esMax;
            for (prima = 0.0; prima > minimo; prima -= scala) {
            }
            while (prima < minimo) {
                prima += scala;
            }
            if (lineeEsterne) {
                prima -= scala;
            }
            while (prima < massimo) {
                this.linee.add(prima);
                prima += scala;
            }
            if (lineeEsterne) {
                this.linee.add(prima);
            }
        }
    }

    @Override
    public double getLowerLine() throws NoGridLine {
        if (this.linee.isEmpty()) {
            throw new NoGridLine();
        }
        double ret = this.linee.get(0);
        for (Double d : this.linee) {
            if (!(d < ret)) continue;
            ret = d;
        }
        return ret;
    }

    @Override
    public double getUpperLine() throws NoGridLine {
        if (this.linee.isEmpty()) {
            throw new NoGridLine();
        }
        double ret = this.linee.get(0);
        for (Double d : this.linee) {
            if (!(d > ret)) continue;
            ret = d;
        }
        return ret;
    }

    @Override
    public List<Double> getLines() {
        return this.linee;
    }
}

