/*
 * Decompiled with CFR 0.152.
 */
package forestplot.api;

import forestplot.api.IGrid;
import forestplot.api.IScale;
import forestplot.api.LinearGrid;
import forestplot.api.NoGridLine;
import forestplot.api.PlotInputData;
import org.openide.util.NbPreferences;

public class LinearScale
implements IScale {
    private final PlotInputData plotInputData;
    private LinearGrid linearGrid;
    private double min;
    private double max;

    public LinearScale(PlotInputData plotInputData) {
        this.plotInputData = plotInputData;
        this.linearGrid = new LinearGrid(this.plotInputData.getMinValue(), this.plotInputData.getMaxValue(), plotInputData.getZeroLineValue(), 4, NbPreferences.root().get("external_lines", "true").equals("true"));
        try {
            this.max = this.linearGrid.getUpperLine() > this.plotInputData.getMaxValue() ? this.linearGrid.getUpperLine() : this.plotInputData.getMaxValue();
            this.min = this.linearGrid.getLowerLine() < this.plotInputData.getMinValue() ? this.linearGrid.getLowerLine() : this.plotInputData.getMinValue();
        }
        catch (NoGridLine ex) {
            this.max = this.plotInputData.getMaxValue();
            this.min = this.plotInputData.getMinValue();
        }
    }

    @Override
    public double fromPressToCalculation(double value) {
        return value;
    }

    @Override
    public double fromCalculationToPress(double value) {
        return value;
    }

    @Override
    public IGrid getGrid() {
        return this.linearGrid;
    }

    @Override
    public double getMaxValueOfForestPlotGraph() {
        return this.max;
    }

    @Override
    public double getMinValueOfForestPlotGraph() {
        return this.min;
    }
}

