/*
 * Decompiled with CFR 0.152.
 */
package forestplot.api;

import forestplot.api.IGrid;
import forestplot.api.IScale;
import forestplot.api.LogGrid;
import forestplot.api.NoGridLine;
import forestplot.api.OutOfRangeInputValueException;
import forestplot.api.PlotInputData;
import forestplot.api.ScaleDataInputErrorException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class LogScale
implements IScale {
    private final PlotInputData plotInputData;
    private LogGrid logGrid;
    private double min;
    private double max;

    public LogScale(PlotInputData plotInputData) throws ScaleDataInputErrorException {
        this.plotInputData = plotInputData;
        if (plotInputData.getMinValue() <= 0.0) {
            throw new ScaleDataInputErrorException(NbBundle.getMessage(LogScale.class, (String)"scale.log.inputerror"));
        }
        this.logGrid = new LogGrid(this.plotInputData.getMinValue(), this.plotInputData.getMaxValue(), NbPreferences.root().get("external_lines", "true").equals("true"));
        try {
            this.max = this.logGrid.getUpperLine() > this.plotInputData.getMaxValue() ? this.logGrid.getUpperLine() : this.plotInputData.getMaxValue();
            this.min = this.logGrid.getLowerLine() < this.plotInputData.getMinValue() ? this.logGrid.getLowerLine() : this.plotInputData.getMinValue();
        }
        catch (NoGridLine ex) {
            this.max = this.plotInputData.getMaxValue();
            this.min = this.plotInputData.getMinValue();
        }
    }

    @Override
    public double fromPressToCalculation(double value) throws OutOfRangeInputValueException {
        if (value <= 0.0) {
            throw new OutOfRangeInputValueException(NbBundle.getMessage(LogScale.class, (String)"scale.logscale.error", (Object)("" + value)));
        }
        return Math.log(value);
    }

    @Override
    public double fromCalculationToPress(double value) {
        return Math.exp(value);
    }

    @Override
    public IGrid getGrid() {
        return this.logGrid;
    }

    @Override
    public double getMaxValueOfForestPlotGraph() {
        return this.max;
    }

    @Override
    public double getMinValueOfForestPlotGraph() {
        return this.min;
    }
}

