/*
 * Decompiled with CFR 0.152.
 */
package forestplot.api;

import forestplot.api.Blocchi;
import forestplot.api.BloccoDiRighe;
import forestplot.api.DataEntryRow;
import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.api.VisualizerBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PlotInputData {
    private VisualizerBean visualizerBean = new VisualizerBean();
    private Blocchi blocchiRighe = new Blocchi();
    private Blocchi blocchiRigheOriginali = new Blocchi();
    private List<IColonna> colonne = new ArrayList<IColonna>();
    private double zeroLineValue = 0.0;

    public VisualizerBean getVisualizerBean() {
        return this.visualizerBean;
    }

    public void setVisualizerBean(VisualizerBean visualizerBean) {
        this.visualizerBean = visualizerBean;
    }

    public Blocchi getBlocchiRighe() {
        return this.blocchiRighe;
    }

    public List<IForestPlotRow> getAllRows() {
        ArrayList<IForestPlotRow> ret = new ArrayList<IForestPlotRow>();
        for (BloccoDiRighe b : this.getBlocchiRighe()) {
            ret.addAll(b);
        }
        return ret;
    }

    public int getAllRowsNumber() {
        int ret = 0;
        for (BloccoDiRighe b : this.getBlocchiRighe()) {
            ret += b.size();
        }
        return ret;
    }

    private void markOriginalRows() {
        this.blocchiRigheOriginali = new Blocchi();
        for (BloccoDiRighe b : this.getBlocchiRighe()) {
            BloccoDiRighe tmp = new BloccoDiRighe();
            for (IForestPlotRow r : b) {
                tmp.add(r);
            }
            this.blocchiRigheOriginali.add(tmp);
        }
    }

    public void loadOriginalRows() {
        this.blocchiRighe = new Blocchi();
        for (BloccoDiRighe b : this.blocchiRigheOriginali) {
            BloccoDiRighe tmp = new BloccoDiRighe();
            for (IForestPlotRow r : b) {
                tmp.add(r);
            }
            this.blocchiRighe.add(tmp);
        }
    }

    public List<IColonna> getColonne() {
        return this.colonne;
    }

    public void setColonne(List<IColonna> colonne) {
        this.colonne = colonne;
    }

    public void sort(Comparator<IForestPlotRow> c) {
        for (BloccoDiRighe br : this.getBlocchiRighe()) {
            Collections.sort(br, c);
        }
    }

    public double getMaxValue() {
        double max = -9.999999999E9;
        for (IForestPlotRow row : this.getAllRows()) {
            double upper = row.getUpperLimit();
            if (!(upper > max)) continue;
            max = upper;
        }
        if (this.getZeroLineValue() > max) {
            return this.getZeroLineValue();
        }
        return max;
    }

    public double getMinValue() {
        double min = 9.999999999E9;
        for (IForestPlotRow row : this.getAllRows()) {
            double lower = row.getLowerLimit();
            if (!(lower < min)) continue;
            min = lower;
        }
        if (this.getZeroLineValue() < min) {
            return this.getZeroLineValue();
        }
        return min;
    }

    public double getMaxWeightFromDataEntryRows() {
        double max = -9.999999999E9;
        for (IForestPlotRow row : this.getAllRows()) {
            double m;
            if (!(row instanceof DataEntryRow) || !((m = row.getWeight()) > max)) continue;
            max = m;
        }
        return max;
    }

    public double getZeroLineValue() {
        return this.zeroLineValue;
    }

    public void setZeroLineValue(double zeroLineValue) {
        this.zeroLineValue = zeroLineValue;
    }

    private void showHidColoumnOnVisualizerBean() {
        if (this.getVisualizerBean() == null) {
            return;
        }
        for (IColonna c : this.colonne) {
            boolean trovata = false;
            for (String xxx : this.getVisualizerBean().getColonneVisualizzate()) {
                if (!xxx.equals(c.getName())) continue;
                c.setShowInTable(true);
                trovata = true;
            }
            c.setShowInTable(trovata);
        }
    }

    public void setUp() {
        this.markOriginalRows();
        if (this.visualizerBean.getComparator() != null) {
            this.sort(this.visualizerBean.getComparator());
        }
        this.showHidColoumnOnVisualizerBean();
    }
}

