/*
 * Decompiled with CFR 0.152.
 */
package forestplot.frame;

import forestplot.api.ForestPlotException;
import forestplot.api.Grafico;
import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.api.IScale;
import forestplot.api.PlotInputData;
import forestplot.frame.JMenuSort;
import formattazione.numeri.MyNumberFormatter;
import gui.alerts.GuiAlerts;
import java.awt.BorderLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.util.NbBundle;

public class ForestPlotMainFrame
extends JFrame
implements ItemListener,
ActionListener {
    private final PlotInputData plotInputData;
    private JMenu optionMenu = new JMenu(NbBundle.getMessage(ForestPlotMainFrame.class, (String)"Frame.options"));
    private JMenu menuSort = new JMenu(NbBundle.getMessage(ForestPlotMainFrame.class, (String)"Frame.sort"));
    private JMenu menuExport = new JMenu(NbBundle.getMessage(ForestPlotMainFrame.class, (String)"Frame.export"));
    private HashMap<String, IColonna> colonneSelezionate = new HashMap();
    private HashMap<String, Comparator<IForestPlotRow>> ordinatori = new HashMap();
    private Grafico grafico = null;
    private final IScale scale;
    private final MyNumberFormatter myNumberFormatter;

    public ForestPlotMainFrame(String name, final PlotInputData plotInputData, IScale scale, int width, int height, MyNumberFormatter myNumberFormatter) throws ForestPlotException {
        super(name);
        this.setSize(width, height);
        this.setLayout(new BorderLayout());
        this.plotInputData = plotInputData;
        this.setIconImage(new ImageIcon(this.getClass().getResource("/forestplot/frame/cippy.png")).getImage());
        this.scale = scale;
        this.myNumberFormatter = myNumberFormatter;
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent ce) {
                try {
                    ForestPlotMainFrame.this.resizePlot();
                }
                catch (ForestPlotException ex) {
                    GuiAlerts.whatAnError((String)ex.getMessage());
                }
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
            }

            @Override
            public void componentShown(ComponentEvent ce) {
            }

            @Override
            public void componentHidden(ComponentEvent ce) {
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        for (IColonna col : this.plotInputData.getColonne()) {
            this.colonneSelezionate.put(col.getName(), col);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(col.getName());
            jCheckBoxMenuItem.setSelected(col.isShowInTable());
            jCheckBoxMenuItem.addItemListener(this);
            this.optionMenu.add(jCheckBoxMenuItem);
        }
        JCheckBoxMenuItem grid = new JCheckBoxMenuItem("Grid");
        grid.setSelected(this.plotInputData.getVisualizerBean().isGrid());
        grid.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                Object item = ie.getItem();
                String text = ((JCheckBoxMenuItem)item).getText();
                plotInputData.getVisualizerBean().setGrid(((JCheckBoxMenuItem)item).isSelected());
                try {
                    ForestPlotMainFrame.this.plotta(ForestPlotMainFrame.this.getContentPane().getWidth(), ForestPlotMainFrame.this.getContentPane().getHeight());
                }
                catch (ForestPlotException ex) {
                    GuiAlerts.whatAnError((String)ex.getMessage());
                }
            }
        });
        this.optionMenu.add(grid);
        JCheckBoxMenuItem zeroLine = new JCheckBoxMenuItem("Null effect size line");
        zeroLine.setSelected(this.plotInputData.getVisualizerBean().isZeroLine());
        zeroLine.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                Object item = ie.getItem();
                String text = ((JCheckBoxMenuItem)item).getText();
                plotInputData.getVisualizerBean().setZeroLine(((JCheckBoxMenuItem)item).isSelected());
                try {
                    ForestPlotMainFrame.this.plotta(ForestPlotMainFrame.this.getContentPane().getWidth(), ForestPlotMainFrame.this.getContentPane().getHeight());
                }
                catch (ForestPlotException ex) {
                    GuiAlerts.whatAnError((String)ex.getMessage());
                }
            }
        });
        this.optionMenu.add(zeroLine);
        JCheckBoxMenuItem overallLines = new JCheckBoxMenuItem("Overall lines");
        overallLines.setSelected(this.plotInputData.getVisualizerBean().isOverallLine());
        overallLines.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                Object item = ie.getItem();
                String text = ((JCheckBoxMenuItem)item).getText();
                plotInputData.getVisualizerBean().setOverallLine(((JCheckBoxMenuItem)item).isSelected());
                try {
                    ForestPlotMainFrame.this.plotta(ForestPlotMainFrame.this.getContentPane().getWidth(), ForestPlotMainFrame.this.getContentPane().getHeight());
                }
                catch (ForestPlotException ex) {
                    GuiAlerts.whatAnError((String)ex.getMessage());
                }
            }
        });
        this.optionMenu.add(overallLines);
        for (IColonna col : this.plotInputData.getColonne()) {
            Comparator<IForestPlotRow> descendingComparator;
            Comparator<IForestPlotRow> ascendingComparator = col.getAscendingComparator();
            if (ascendingComparator != null) {
                this.ordinatori.put(ascendingComparator.toString(), ascendingComparator);
                JMenuSort jMenuSort = new JMenuSort(ascendingComparator.toString());
                this.menuSort.add(jMenuSort);
                jMenuSort.addActionListener(this);
            }
            if ((descendingComparator = col.getDescendingComparator()) == null) continue;
            this.ordinatori.put(descendingComparator.toString(), descendingComparator);
            JMenuSort jMenuSortb = new JMenuSort(descendingComparator.toString());
            this.menuSort.add(jMenuSortb);
            jMenuSortb.addActionListener(this);
        }
        JMenuSort jMenuSort = new JMenuSort("ORIGINAL ORDER");
        this.menuSort.add(jMenuSort);
        jMenuSort.addActionListener(this);
        JMenuItem esportaImmagine = new JMenuItem("Save as image");
        esportaImmagine.addItemListener(this);
        this.menuExport.add(esportaImmagine);
        esportaImmagine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ForestPlotMainFrame.this.salvaImmagine();
            }
        });
        menuBar.add(this.optionMenu);
        menuBar.add(this.menuSort);
        menuBar.add(this.menuExport);
    }

    private void resizePlot() throws ForestPlotException {
        this.plotta(this.getContentPane().getWidth(), this.getContentPane().getHeight());
    }

    private void plotta(int width, int height) throws ForestPlotException {
        this.getContentPane().removeAll();
        this.grafico = new Grafico(this.plotInputData, this.scale, width, height, this.getGraphics(), this.myNumberFormatter);
        this.add(this.grafico);
        this.validate();
        this.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object item = ie.getItem();
        if (item instanceof JCheckBoxMenuItem) {
            String text = ((JCheckBoxMenuItem)item).getText();
            this.colonneSelezionate.get(text).setShowInTable(((JCheckBoxMenuItem)item).isSelected());
            this.plotInputData.getVisualizerBean().setColonneVisualizzate(this.elencaColonneVisualizzate());
            try {
                this.plotta(this.getContentPane().getWidth(), this.getContentPane().getHeight());
            }
            catch (ForestPlotException ex) {
                GuiAlerts.whatAnError((String)ex.getMessage());
            }
        }
    }

    private String[] elencaColonneVisualizzate() {
        ArrayList<String> xxx = new ArrayList<String>();
        for (IColonna c : this.colonneSelezionate.values()) {
            if (!c.isShowInTable()) continue;
            xxx.add(c.getName());
        }
        return xxx.toArray(new String[xxx.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source instanceof JMenuSort) {
            String text = ((JMenuSort)source).getText();
            if (text.equals("ORIGINAL ORDER")) {
                this.plotInputData.getVisualizerBean().setComparator(null);
                this.plotInputData.loadOriginalRows();
            } else {
                this.plotInputData.sort(this.ordinatori.get(text));
                this.plotInputData.getVisualizerBean().setComparator(this.ordinatori.get(text));
            }
            try {
                this.plotta(this.getContentPane().getWidth(), this.getContentPane().getHeight());
            }
            catch (ForestPlotException ex) {
                GuiAlerts.whatAnError((String)ex.getMessage());
            }
        }
    }

    public void salvaImmagine() {
        if (this.grafico == null) {
            return;
        }
        BufferedImage bi = new BufferedImage(this.grafico.getWidth(), this.grafico.getHeight(), 1);
        Graphics2D g = bi.createGraphics();
        this.grafico.paint(g);
        g.dispose();
        JFileChooser fc = new JFileChooser();
        FileNameExtensionFilter pngFilter = new FileNameExtensionFilter("File PNG", "png");
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(pngFilter);
        int returnVal = fc.showSaveDialog(fc);
        if (returnVal == 0) {
            String msg;
            int r;
            File f = fc.getSelectedFile();
            FileFilter selectedFilter = fc.getFileFilter();
            if (f.exists() && (r = JOptionPane.showConfirmDialog(null, msg = MessageFormat.format("The file ''{0}'' already exist.\nDo you want to override?", f), "Confirm", 0)) == 1) {
                return;
            }
            if (selectedFilter == pngFilter) {
                String estensione = ".png";
                if (f.getName().endsWith(estensione)) {
                    estensione = "";
                }
                try {
                    ImageIO.write((RenderedImage)bi, "png", new File(f.getPath() + estensione));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

