/*
 * Decompiled with CFR 0.152.
 */
package forestplot.frame;

import forestplot.api.AbstractGeometra;
import forestplot.api.IForestPlotRow;
import forestplot.api.IGeometra;
import forestplot.api.OverallRow;
import forestplot.api.PlotInputData;

public class StandardGeometra
extends AbstractGeometra
implements IGeometra {
    private double altezzaSeparatoreBlocchiPrecisa;
    private double altezzaRigaDataEntryPrecisa;
    private double altezzaRigaOverallPrecisa;
    private int usefullHeight;
    private int usefullWidth;
    private int altezzaTitoliTesta;
    private int altezzaTitoliCoda;
    private int margineSinistro;
    private int margineDestro;
    private int margineSuperiore;
    private int margineInferiore;
    private int altezzaCentrale;

    public StandardGeometra(int originalWidth, int originalHeight, PlotInputData plotInputData, int margineSuperiore, int margineDestro, int margineInferiore, int margineSinistro) {
        super(originalWidth, originalHeight, plotInputData);
        double altezzaRigaNormale;
        this.margineDestro = margineDestro;
        this.margineInferiore = margineInferiore;
        this.margineSinistro = margineSinistro;
        this.margineSuperiore = margineSuperiore;
        int numeroBlocchi = this.getPlotInputData().getBlocchiRighe().size();
        int righeDataEntry = this.getPlotInputData().getBlocchiRighe().getDataEntryRowsNumber();
        int righeOverall = this.getPlotInputData().getBlocchiRighe().getOverallRowsNumber();
        this.usefullHeight = originalHeight - this.margineInferiore - this.margineSuperiore;
        this.usefullWidth = originalWidth - this.margineSinistro - this.margineDestro;
        this.altezzaTitoliTesta = this.usefullHeight / (plotInputData.getAllRowsNumber() + 2);
        this.altezzaTitoliCoda = this.usefullHeight / (plotInputData.getAllRowsNumber() + 2) + 25;
        this.altezzaCentrale = this.usefullHeight - this.altezzaTitoliTesta - this.altezzaTitoliCoda;
        this.altezzaSeparatoreBlocchiPrecisa = numeroBlocchi <= 1 ? 0.0 : (double)this.altezzaCentrale / (1.0 * (double)numeroBlocchi) * 0.1;
        this.altezzaRigaDataEntryPrecisa = altezzaRigaNormale = ((double)this.altezzaCentrale - this.altezzaSeparatoreBlocchiPrecisa * (double)(numeroBlocchi - 1)) / (coefficienteAltezzaOverall * (double)righeOverall + (double)righeDataEntry);
        this.altezzaRigaOverallPrecisa = altezzaRigaNormale * coefficienteAltezzaOverall;
    }

    @Override
    public int getUsefullWidth() {
        return this.usefullWidth;
    }

    @Override
    public int getUsefullHeight() {
        return this.usefullHeight;
    }

    @Override
    public int getMargineHeader() {
        return this.margineSuperiore;
    }

    @Override
    public int getMargineBottom() {
        return this.margineInferiore;
    }

    @Override
    public int getMargineSinistro() {
        return this.margineSinistro;
    }

    @Override
    public int getMargineDestro() {
        return this.margineDestro;
    }

    @Override
    public double getAltezzaRigaDataEntryPrecisa() {
        return this.altezzaRigaDataEntryPrecisa;
    }

    @Override
    public double getAltezzaRigaOverallPrecisa() {
        return this.altezzaRigaOverallPrecisa;
    }

    @Override
    public int getAltezzaTitoliTesta() {
        return this.altezzaTitoliTesta;
    }

    @Override
    public int getAltezzaTitoliCoda() {
        return this.altezzaTitoliCoda;
    }

    @Override
    public int getAltezzaRigaDataEntryIntera() {
        return (int)this.altezzaRigaDataEntryPrecisa;
    }

    @Override
    public int getAltezzaRigaOverallIntera() {
        return (int)this.altezzaRigaOverallPrecisa;
    }

    @Override
    public int getAltezzaSeparatoreBlocchi() {
        return (int)this.altezzaSeparatoreBlocchiPrecisa;
    }

    @Override
    public double getAltezzaSeparatoreBlocchiPrecisa() {
        return this.altezzaSeparatoreBlocchiPrecisa;
    }

    @Override
    public double getAltezzaRigaPrecisa(IForestPlotRow row) {
        if (row instanceof OverallRow) {
            return this.getAltezzaRigaOverallPrecisa();
        }
        return this.getAltezzaRigaDataEntryPrecisa();
    }

    @Override
    public int getAltezzaRigaIntera(IForestPlotRow row) {
        if (row instanceof OverallRow) {
            return this.getAltezzaRigaOverallIntera();
        }
        return this.getAltezzaRigaDataEntryIntera();
    }

    public int getAltezzaCentrale() {
        return this.altezzaCentrale;
    }

    public void setAltezzaCentrale(int altezzaCentrale) {
        this.altezzaCentrale = altezzaCentrale;
    }

    @Override
    public int getCentralHeight() {
        return this.altezzaCentrale;
    }
}

