/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.tables.AColonna;
import forestplot.tables.ColonnaNome;
import java.text.DecimalFormat;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ColonnaConfidenceInterval
extends AColonna
implements IColonna {
    private DecimalFormat decimalFormat;

    public ColonnaConfidenceInterval(DecimalFormat decimalFormat) {
        super(false);
        this.decimalFormat = decimalFormat;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.ic.name");
    }

    @Override
    public String getShortName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.ic.shortname");
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.ic.tooltip");
    }

    @Override
    public String getValue(IForestPlotRow row) {
        if (row.getLowerLimit() == null || row.getUpperLimit() == null) {
            return "";
        }
        return this.decimalFormat.format(row.getLowerLimit()) + " " + NbPreferences.root().get("ci_separator", "/") + " " + this.decimalFormat.format(row.getUpperLimit());
    }
}

