/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.tables.AColonna;
import forestplot.tables.ColonnaNome;
import forestplot.tables.ComparatorByEffectSizeAscending;
import forestplot.tables.ComparatorByEffectSizeDescending;
import java.text.DecimalFormat;
import java.util.Comparator;
import org.openide.util.NbBundle;

public class ColonnaEffectsize
extends AColonna
implements IColonna {
    private DecimalFormat decimalFormat;

    public ColonnaEffectsize(DecimalFormat decimalFormat) {
        super(false);
        this.decimalFormat = decimalFormat;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.es.name");
    }

    @Override
    public String getShortName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.es.shortname");
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.es.tooltip");
    }

    @Override
    public String getValue(IForestPlotRow row) {
        if (row.getEffectSize() == null) {
            return "";
        }
        return this.decimalFormat.format(row.getEffectSize());
    }

    @Override
    public Comparator<IForestPlotRow> getAscendingComparator() {
        return new ComparatorByEffectSizeAscending();
    }

    @Override
    public Comparator<IForestPlotRow> getDescendingComparator() {
        return new ComparatorByEffectSizeDescending();
    }
}

