/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.tables.AColonna;
import forestplot.tables.ColonnaNome;
import forestplot.tables.ComparatorByN1Ascending;
import forestplot.tables.ComparatorByN1Descending;
import formattazione.numeri.MyNumberFormatter;
import java.util.Comparator;
import org.openide.util.NbBundle;

public class ColonnaN1
extends AColonna
implements IColonna {
    private final MyNumberFormatter formatter;

    public ColonnaN1(MyNumberFormatter formatter) {
        super(false);
        this.formatter = formatter;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.n1.name");
    }

    @Override
    public String getShortName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.n1.shortname");
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.n1.tooltip");
    }

    @Override
    public String getValue(IForestPlotRow row) {
        return this.formatter.formatInLang(row.getN1());
    }

    @Override
    public Comparator<IForestPlotRow> getAscendingComparator() {
        return new ComparatorByN1Ascending();
    }

    @Override
    public Comparator<IForestPlotRow> getDescendingComparator() {
        return new ComparatorByN1Descending();
    }
}

