/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.tables.AColonna;
import forestplot.tables.ColonnaNome;
import forestplot.tables.ComparatorByN2Ascending;
import forestplot.tables.ComparatorByN2Descending;
import formattazione.numeri.MyNumberFormatter;
import java.util.Comparator;
import org.openide.util.NbBundle;

public class ColonnaN2
extends AColonna
implements IColonna {
    private final MyNumberFormatter myNumberFormatter;

    public ColonnaN2(MyNumberFormatter myNumberFormatter) {
        super(false);
        this.myNumberFormatter = myNumberFormatter;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.n2.name");
    }

    @Override
    public String getShortName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.n2.shortname");
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.n2.tooltip");
    }

    @Override
    public String getValue(IForestPlotRow row) {
        return this.myNumberFormatter.formatInLang(row.getN2());
    }

    @Override
    public Comparator<IForestPlotRow> getAscendingComparator() {
        return new ComparatorByN2Ascending();
    }

    @Override
    public Comparator<IForestPlotRow> getDescendingComparator() {
        return new ComparatorByN2Descending();
    }
}

