/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.tables.AColonna;
import forestplot.tables.ColonnaNome;
import forestplot.tables.ComparatorBySigAscending;
import forestplot.tables.ComparatorBySigDescending;
import java.text.DecimalFormat;
import java.util.Comparator;
import org.openide.util.NbBundle;

public class ColonnaPValue
extends AColonna
implements IColonna {
    private DecimalFormat decimalFormat;

    public ColonnaPValue(DecimalFormat decimalFormat) {
        super(false);
        this.decimalFormat = decimalFormat;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.p.name");
    }

    @Override
    public String getShortName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.p.shortname");
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.p.tooltip");
    }

    @Override
    public String getValue(IForestPlotRow row) {
        if (row.getPValue() == null) {
            return "";
        }
        return this.decimalFormat.format(row.getPValue());
    }

    @Override
    public Comparator<IForestPlotRow> getAscendingComparator() {
        return new ComparatorBySigAscending();
    }

    @Override
    public Comparator<IForestPlotRow> getDescendingComparator() {
        return new ComparatorBySigDescending();
    }
}

