/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.tables.AColonna;
import forestplot.tables.ColonnaNome;
import forestplot.tables.ComparatorByWeightAscending;
import forestplot.tables.ComparatorByWeightDescending;
import java.text.DecimalFormat;
import java.util.Comparator;
import org.openide.util.NbBundle;

public class ColonnaPesoPercentuale
extends AColonna
implements IColonna {
    private DecimalFormat decimalFormat;

    public ColonnaPesoPercentuale(DecimalFormat decimalFormat) {
        super(false);
        this.decimalFormat = decimalFormat;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.w.name");
    }

    @Override
    public String getShortName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.w.shortname");
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.w.tooltip");
    }

    @Override
    public String getValue(IForestPlotRow row) {
        return this.decimalFormat.format(row.getWeight()) + "%";
    }

    @Override
    public Comparator<IForestPlotRow> getAscendingComparator() {
        return new ComparatorByWeightAscending();
    }

    @Override
    public Comparator<IForestPlotRow> getDescendingComparator() {
        return new ComparatorByWeightDescending();
    }
}

