/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.tables.AColonna;
import forestplot.tables.ColonnaNome;
import forestplot.tables.ComparatorByStandardErrorAscending;
import forestplot.tables.ComparatorByStandardErrorDescending;
import java.text.DecimalFormat;
import java.util.Comparator;
import org.openide.util.NbBundle;

public class ColonnaStandardError
extends AColonna
implements IColonna {
    private DecimalFormat decimalFormat;

    public ColonnaStandardError(DecimalFormat decimalFormat) {
        super(false);
        this.decimalFormat = decimalFormat;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.se.name");
    }

    @Override
    public String getShortName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.se.shortname");
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.se.tooltip");
    }

    @Override
    public String getValue(IForestPlotRow row) {
        if (row.getStandardError() == null) {
            return "";
        }
        return this.decimalFormat.format(row.getStandardError());
    }

    @Override
    public Comparator<IForestPlotRow> getAscendingComparator() {
        return new ComparatorByStandardErrorAscending();
    }

    @Override
    public Comparator<IForestPlotRow> getDescendingComparator() {
        return new ComparatorByStandardErrorDescending();
    }
}

