/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.tables.AColonna;
import forestplot.tables.ColonnaNome;
import forestplot.tables.ComparatorBySampleSizeAscending;
import forestplot.tables.ComparatorBySampleSizeDescending;
import formattazione.numeri.MyNumberFormatter;
import java.util.Comparator;
import org.openide.util.NbBundle;

public class ColonnaTotalSampleSize
extends AColonna
implements IColonna {
    private final MyNumberFormatter formatter;

    public ColonnaTotalSampleSize(MyNumberFormatter formatter) {
        super(false);
        this.formatter = formatter;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.ss.name");
    }

    @Override
    public String getShortName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.ss.shortname");
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.ss.tooltip");
    }

    @Override
    public String getValue(IForestPlotRow row) {
        return this.formatter.formatInLang(row.getSampleSize());
    }

    @Override
    public Comparator<IForestPlotRow> getAscendingComparator() {
        return new ComparatorBySampleSizeAscending();
    }

    @Override
    public Comparator<IForestPlotRow> getDescendingComparator() {
        return new ComparatorBySampleSizeDescending();
    }
}

