/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.tables.AColonna;
import forestplot.tables.ColonnaNome;
import forestplot.tables.ComparatorByVarianceAscending;
import forestplot.tables.ComparatorByVarianceDescending;
import java.text.DecimalFormat;
import java.util.Comparator;
import org.openide.util.NbBundle;

public class ColonnaVarianza
extends AColonna
implements IColonna {
    private DecimalFormat decimalFormat;

    public ColonnaVarianza(DecimalFormat decimalFormat) {
        super(false);
        this.decimalFormat = decimalFormat;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.variance.name");
    }

    @Override
    public String getShortName() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.variance.shortname");
    }

    @Override
    public String getTooltip() {
        return NbBundle.getMessage(ColonnaNome.class, (String)"fields.variance.tooltip");
    }

    @Override
    public String getValue(IForestPlotRow row) {
        if (row.getVariance() == null) {
            return "";
        }
        return this.decimalFormat.format(row.getVariance());
    }

    @Override
    public Comparator<IForestPlotRow> getAscendingComparator() {
        return new ComparatorByVarianceAscending();
    }

    @Override
    public Comparator<IForestPlotRow> getDescendingComparator() {
        return new ComparatorByVarianceDescending();
    }
}

