/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.Blocchi;
import forestplot.api.BloccoDiRighe;
import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;

public class GeometraColonna {
    private final FontMetrics fm;
    private final IColonna col;
    private final List<IForestPlotRow> rows;
    private int larghezza = 0;

    public GeometraColonna(FontMetrics fm, IColonna col, Blocchi blocchi) {
        this.rows = new ArrayList<IForestPlotRow>();
        this.fm = fm;
        this.col = col;
        for (BloccoDiRighe b : blocchi) {
            this.rows.addAll(b);
        }
        this.elabora();
    }

    public GeometraColonna(FontMetrics fm, IColonna col, List<IForestPlotRow> rows) {
        this.fm = fm;
        this.col = col;
        this.rows = rows;
        this.elabora();
    }

    private void elabora() {
        for (IForestPlotRow row : this.rows) {
            int width;
            if (this.col.getValue(row) == null || (width = this.fm.stringWidth(this.col.getValue(row))) <= this.larghezza) continue;
            this.larghezza = width;
        }
        int width = this.fm.stringWidth("XXX");
        if (width > this.larghezza) {
            this.larghezza = width;
        }
    }

    public int getLarghezza() {
        return this.larghezza;
    }
}

