/*
 * Decompiled with CFR 0.152.
 */
package forestplot.tables;

import forestplot.api.BloccoDiRighe;
import forestplot.api.IColonna;
import forestplot.api.IForestPlotRow;
import forestplot.api.IGeometra;
import forestplot.api.PlotInputData;
import forestplot.graph.objects.MyLabel;
import forestplot.tables.GeometraColonna;
import forestplot.tables.TabellaJPanel;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Tabella {
    private final PlotInputData plotInputData;
    private final IGeometra geometra;
    private Font font;
    private int distanzaColonne = 15;
    private int width = 0;
    private FontMetrics fontMetrics;
    private TabellaJPanel panel = new TabellaJPanel();

    public Tabella(PlotInputData plotInputData, IGeometra geometra, Font font, Graphics g) {
        this.font = font;
        this.plotInputData = plotInputData;
        this.geometra = geometra;
        this.fontMetrics = g.getFontMetrics(font);
        boolean blocchiFatti = false;
        int blocchiTotali = plotInputData.getBlocchiRighe().size();
        this.impostaLarghezzaColonneELarghezzaTabella();
        this.aggiungiTitoli();
        this.aggiungiRighe();
        this.panel.setSize(this.width, geometra.getUsefullHeight());
    }

    public int getWidth() {
        return this.width;
    }

    public TabellaJPanel getPanel() {
        return this.panel;
    }

    public int getHeight() {
        return this.geometra.getUsefullHeight();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getDistanzaColonne() {
        return this.distanzaColonne;
    }

    public void setDistanzaColonne(int distanzaColonne) {
        this.distanzaColonne = distanzaColonne;
    }

    private void aggiungiTitoli() {
        Font fontTitoli = new Font(this.font.getFamily(), 1, this.font.getSize() + 1);
        int distanzaDalLatoXTitoli = 0;
        for (IColonna c : this.plotInputData.getColonne()) {
            if (!c.isShowInTable()) continue;
            MyLabel xxx = new MyLabel(c.getShortName() + "  ");
            xxx.setToolTipText(c.getTooltip());
            xxx.setFont(fontTitoli);
            xxx.setHorizontalAlignment(4);
            xxx.setBounds(distanzaDalLatoXTitoli, 0, c.getWidth(), this.geometra.getAltezzaTitoliTesta());
            this.panel.add(xxx);
            distanzaDalLatoXTitoli += c.getWidth();
        }
    }

    private void aggiungiRighe() {
        int blocchi = 0;
        double distanzaCopertaDalleRighe = 0.0;
        for (BloccoDiRighe b : this.plotInputData.getBlocchiRighe()) {
            for (IForestPlotRow row : b) {
                int distanzaDalLato = 0;
                for (IColonna col : this.plotInputData.getColonne()) {
                    if (!col.isShowInTable()) continue;
                    MyLabel xxx = new MyLabel(col.getValue(row));
                    xxx.setFont(this.font);
                    xxx.setHorizontalAlignment(col.getStile().getAllineamento());
                    xxx.setBounds(distanzaDalLato, this.geometra.getAltezzaTitoliTesta() + blocchi * this.geometra.getAltezzaSeparatoreBlocchi() + (int)distanzaCopertaDalleRighe, col.getWidth(), this.geometra.getAltezzaRigaIntera(row));
                    this.panel.add(xxx);
                    distanzaDalLato += col.getWidth();
                }
                distanzaCopertaDalleRighe += this.geometra.getAltezzaRigaPrecisa(row);
            }
            ++blocchi;
        }
    }

    private void impostaLarghezzaColonneELarghezzaTabella() {
        for (IColonna c : this.plotInputData.getColonne()) {
            GeometraColonna gc = new GeometraColonna(this.fontMetrics, c, this.plotInputData.getBlocchiRighe());
            int la = (int)((double)gc.getLarghezza() * 1.1) + 1;
            c.setWidth(la + this.distanzaColonne);
            if (!c.isShowInTable()) continue;
            this.width += la + this.distanzaColonne;
        }
    }
}

