/*
 * Decompiled with CFR 0.152.
 */
package forestplot.util;

public class FromESToPixelConverter {
    private final double esMin;
    private final double esMax;
    private final double widthInPixel;
    private final int paddingOrizzontale;

    public FromESToPixelConverter(double esMin, double esMax, double widthInPixel, int paddingOrizzontale) {
        this.esMin = esMin;
        this.esMax = esMax;
        this.widthInPixel = widthInPixel - (double)(2 * paddingOrizzontale) < 1.0 ? 1.0 : widthInPixel - (double)(2 * paddingOrizzontale);
        this.paddingOrizzontale = paddingOrizzontale;
    }

    public FromESToPixelConverter(double esMin, double esMax, double widthInPixel) {
        this.esMin = esMin;
        this.esMax = esMax;
        this.widthInPixel = widthInPixel;
        this.paddingOrizzontale = 0;
    }

    public int getPixel(double es) {
        return (int)((es - this.esMin) * this.widthInPixel / (this.esMax - this.esMin) + (double)this.paddingOrizzontale);
    }
}

