/*
 * Decompiled with CFR 0.152.
 */
package forestplot.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtils {
    public static final int IMAGE_UNKNOWN = -1;
    public static final int IMAGE_JPEG = 0;
    public static final int IMAGE_PNG = 1;
    public static final int IMAGE_GIF = 2;

    public static BufferedImage resizeImage(String imgName, int type, int maxWidth, int maxHeight) {
        try {
            return ImageUtils.resizeImage(ImageIO.read(new File(imgName)), type, maxWidth, maxHeight);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage resizeImage(BufferedImage image, int type, int maxWidth, int maxHeight) {
        Dimension largestDimension = new Dimension(maxWidth, maxHeight);
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        float aspectRatio = (float)imageWidth / (float)imageHeight;
        if (imageWidth > maxWidth || imageHeight > maxHeight) {
            if ((float)largestDimension.width / (float)largestDimension.height > aspectRatio) {
                largestDimension.width = (int)Math.ceil((float)largestDimension.height * aspectRatio);
            } else {
                largestDimension.height = (int)Math.ceil((float)largestDimension.width / aspectRatio);
            }
            imageWidth = largestDimension.width;
            imageHeight = largestDimension.height;
            if (imageWidth < 0) {
                imageWidth = 1;
            }
            if (imageHeight < 0) {
                imageHeight = 1;
            }
        }
        return ImageUtils.createHeadlessSmoothBufferedImage(image, type, imageWidth, imageHeight);
    }

    public static boolean saveImage(BufferedImage image, String toFileName, int type) {
        try {
            return ImageIO.write((RenderedImage)image, type == 0 ? "jpg" : "png", new File(toFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void saveCompressedImage(BufferedImage image, String toFileName, int type) {
        try {
            if (type == 1) {
                throw new UnsupportedOperationException("PNG compression not implemented");
            }
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
            ImageWriter writer = iter.next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(toFileName));
            writer.setOutput(ios);
            JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
            iwparam.setCompressionMode(2);
            iwparam.setCompressionQuality(0.7f);
            writer.write(null, new IIOImage(image, null, null), iwparam);
            ios.flush();
            writer.dispose();
            ios.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BufferedImage createHeadlessBufferedImage(BufferedImage image, int type, int width, int height) {
        type = type == 1 && ImageUtils.hasAlpha(image) ? 2 : 1;
        BufferedImage bi = new BufferedImage(width, height, type);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bi.setRGB(x, y, image.getRGB(x * image.getWidth() / width, y * image.getHeight() / height));
            }
        }
        return bi;
    }

    public static BufferedImage createHeadlessSmoothBufferedImage(BufferedImage source, int type, int width, int height) {
        type = type == 1 && ImageUtils.hasAlpha(source) ? 2 : 1;
        BufferedImage dest = new BufferedImage(width, height, type);
        double scalex = (double)width / (double)source.getWidth();
        double scaley = (double)height / (double)source.getHeight();
        for (int y = 0; y < height; ++y) {
            int sourcey = y * source.getHeight() / dest.getHeight();
            double ydiff = ImageUtils.scale(y, scaley) - (double)sourcey;
            for (int x = 0; x < width; ++x) {
                int sourcex = x * source.getWidth() / dest.getWidth();
                double xdiff = ImageUtils.scale(x, scalex) - (double)sourcex;
                int x1 = Math.min(source.getWidth() - 1, sourcex + 1);
                int y1 = Math.min(source.getHeight() - 1, sourcey + 1);
                int rgb1 = ImageUtils.getRGBInterpolation(source.getRGB(sourcex, sourcey), source.getRGB(x1, sourcey), xdiff);
                int rgb2 = ImageUtils.getRGBInterpolation(source.getRGB(sourcex, y1), source.getRGB(x1, y1), xdiff);
                int rgb = ImageUtils.getRGBInterpolation(rgb1, rgb2, ydiff);
                dest.setRGB(x, y, rgb);
            }
        }
        return dest;
    }

    private static double scale(int point, double scale) {
        return (double)point / scale;
    }

    private static int getRGBInterpolation(int value1, int value2, double distance) {
        int alpha1 = (value1 & 0xFF000000) >>> 24;
        int red1 = (value1 & 0xFF0000) >> 16;
        int green1 = (value1 & 0xFF00) >> 8;
        int blue1 = value1 & 0xFF;
        int alpha2 = (value2 & 0xFF000000) >>> 24;
        int red2 = (value2 & 0xFF0000) >> 16;
        int green2 = (value2 & 0xFF00) >> 8;
        int blue2 = value2 & 0xFF;
        int rgb = (int)((double)alpha1 * (1.0 - distance) + (double)alpha2 * distance) << 24 | (int)((double)red1 * (1.0 - distance) + (double)red2 * distance) << 16 | (int)((double)green1 * (1.0 - distance) + (double)green2 * distance) << 8 | (int)((double)blue1 * (1.0 - distance) + (double)blue2 * distance);
        return rgb;
    }

    public static boolean hasAlpha(Image image) {
        try {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
            pg.grabPixels();
            return pg.getColorModel().hasAlpha();
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

