/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.studies;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import metaanalysis.actions.models.DefineOutcomebranchesForComparisonbranchAA;
import metaanalysis.actions.models.DefineTimepointBranchesAA;
import metaanalysis.actions.models.MoveModeratorValueToComparisonbranchAA;
import metaanalysis.actions.models.RemoveComparisonbranchAA;
import metaanalysis.actions.models.SetEffectsizeValueToOutcomebranchAA;
import metaanalysis.core.flavors.ModeratorvalueFlavor;
import metaanalysis.core.flavors.OutcomeFlavor;
import metaanalysis.core.flavors.Timepoint;
import metaanalysis.core.flavors.TimepointFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ComparisonEvents;
import metaanalysis.core.functionsapi.events.ComparisonUpdatedEvent;
import metaanalysis.core.functionsapi.events.ExpandComparisonbranch;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Comparisonbranch;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.effectsize.valuesdefinition.ESVFlavor;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class ComparisonbranchNode
extends AbstractApplicationNode
implements PropertyChangeListener {
    private final Comparisonbranch comparisonbranch;
    private Comparison comparison;

    public ComparisonbranchNode(Comparisonbranch comparisonbranch, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)comparisonbranch));
        this.comparisonbranch = comparisonbranch;
        this.comparison = this.applicationEventWorker.getIDataFunction().getComparison(this.comparisonbranch.getComparisonId().intValue());
        this.setDisplayName(this.comparison.getName());
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/comparison_link_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/comparison_link_iconOpen.png");
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveComparisonbranchAA(this.comparisonbranch, this.applicationEventWorker));
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RemoveAction()};
    }

    public PasteType getDropType(final Transferable t, int arg1, int arg2) {
        ComparisonbranchNode n = this;
        if (t.isDataFlavorSupported(TimepointFlavor.TIMEPOINT_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        ComparisonbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineTimepointBranchesAA(ComparisonbranchNode.this.comparisonbranch, ComparisonbranchNode.getTimepointAmount(t).intValue(), ComparisonbranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(OutcomeFlavor.OUTCOME_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Outcome o = (Outcome)t.getTransferData(OutcomeFlavor.OUTCOME_FLAVOR);
                        ComparisonbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineOutcomebranchesForComparisonbranchAA(ComparisonbranchNode.this.comparisonbranch, o, ComparisonbranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ESVFlavor.ESV_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        IEffectSizeValue es = (IEffectSizeValue)t.getTransferData(ESVFlavor.ESV_FLAVOR);
                        List allOutcomebranchsOfTimepointbranch = ComparisonbranchNode.this.applicationEventWorker.getIDataFunction().getAllOutcomebranchsOfComparisonbranch(ComparisonbranchNode.this.comparisonbranch.getId());
                        for (Outcomebranch tmp : allOutcomebranchsOfTimepointbranch) {
                            ComparisonbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new SetEffectsizeValueToOutcomebranchAA(es, tmp, ComparisonbranchNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Moderatorvalue x = (Moderatorvalue)t.getTransferData(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR);
                        ComparisonbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new MoveModeratorValueToComparisonbranchAA(x, ComparisonbranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType p = this.getDropType(t, 0, 0);
        if (p != null) {
            s.add(p);
        }
    }

    public static Integer getTimepointAmount(Transferable t) throws UnsupportedFlavorException, IOException {
        Timepoint es = (Timepoint)t.getTransferData(TimepointFlavor.TIMEPOINT_FLAVOR);
        String tmp = ComparisonbranchNode.manageTimepoint();
        if (tmp == null) {
            return null;
        }
        int timepointNumber = 1;
        if (!tmp.equals(NbBundle.getMessage(ComparisonbranchNode.class, (String)"defaultTimepoint.label"))) {
            timepointNumber = Integer.parseInt(tmp);
        }
        return timepointNumber;
    }

    private static String manageTimepoint() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(NbBundle.getMessage(ComparisonbranchNode.class, (String)"defaultTimepoint.label"));
        for (int i = 2; i < 1001; ++i) {
            values.add("" + i);
        }
        return (String)JOptionPane.showInputDialog(null, NbBundle.getMessage(ComparisonbranchNode.class, (String)"timepointDialog.description"), NbBundle.getMessage(ComparisonbranchNode.class, (String)"timepointDialog.bartitle"), -1, null, values.toArray(), NbBundle.getMessage(ComparisonbranchNode.class, (String)"defaultTimepoint.label"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent")) {
            if (pce.getNewValue() instanceof ComparisonEvents) {
                if (((ComparisonEvents)pce.getNewValue()).getComparison().getId() == this.comparison.getId() && pce.getNewValue() instanceof ComparisonUpdatedEvent) {
                    ComparisonUpdatedEvent tmp = (ComparisonUpdatedEvent)pce.getNewValue();
                    this.comparison.copyFrom(tmp.getComparison());
                    this.setName(this.comparison.getName());
                    this.setDisplayName(this.comparison.getName());
                }
            } else if (pce.getNewValue() instanceof ExpandComparisonbranch && ((ExpandComparisonbranch)pce.getNewValue()).getComparisonbranch().getId() == this.comparisonbranch.getId()) {
                this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
            }
        }
    }

    private class RemoveAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveAction.class, (String)"Generic.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComparisonbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveComparisonbranchAA(ComparisonbranchNode.this.comparisonbranch, ComparisonbranchNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }
}

