/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.studies;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalysis.actions.models.MoveModeratorValueToOutcomebranchAA;
import metaanalysis.actions.models.RemoveOutcomebranchAA;
import metaanalysis.actions.models.SetEffectsizeValueToOutcomebranchAA;
import metaanalysis.core.flavors.ModeratorvalueFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ExpandOutcomebranch;
import metaanalysis.core.functionsapi.events.OutcomeEvents;
import metaanalysis.core.functionsapi.events.OutcomeUpdatedEvent;
import metaanalysis.core.functionsapi.events.OutcomebranchEvents;
import metaanalysis.core.functionsapi.events.OutcomebranchUpdatedEvent;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.effectsize.valuesdefinition.ESVFlavor;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class OutcomebranchNode
extends AbstractApplicationNode
implements INodeEditor,
PropertyChangeListener {
    private final Outcomebranch outcomebranch;
    private Outcome outcome;

    public OutcomebranchNode(Outcomebranch outcomebranch, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)outcomebranch));
        this.outcomebranch = outcomebranch;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
        this.outcome = this.applicationEventWorker.getIDataFunction().getOutcome(this.outcomebranch.getOutcomeId().intValue());
        this.setDisplayName(this.outcome.getName());
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/outcome_link_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/outcome_link_iconOpen.png");
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveOutcomebranchAA(this.outcomebranch, this.applicationEventWorker));
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RemoveAction()};
    }

    public PasteType getDropType(final Transferable t, int arg1, int arg2) {
        if (t.isDataFlavorSupported(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Moderatorvalue x = (Moderatorvalue)t.getTransferData(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR);
                        OutcomebranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new MoveModeratorValueToOutcomebranchAA(x, OutcomebranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ESVFlavor.ESV_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        IEffectSizeValue es = (IEffectSizeValue)t.getTransferData(ESVFlavor.ESV_FLAVOR);
                        OutcomebranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new SetEffectsizeValueToOutcomebranchAA(es, OutcomebranchNode.this.outcomebranch, OutcomebranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType p = this.getDropType(t, 0, 0);
        if (p != null) {
            s.add(p);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent")) {
            if (pce.getNewValue() instanceof OutcomeEvents) {
                if (((OutcomeEvents)pce.getNewValue()).getOutcome().getId() == this.outcome.getId() && pce.getNewValue() instanceof OutcomeUpdatedEvent) {
                    OutcomeUpdatedEvent tmp = (OutcomeUpdatedEvent)pce.getNewValue();
                    this.outcome.copyFrom(tmp.getOutcome());
                    this.setName(this.outcome.getName());
                    this.setDisplayName(this.outcome.getName());
                }
            } else if (pce.getNewValue() instanceof OutcomebranchEvents) {
                if (((OutcomebranchEvents)pce.getNewValue()).getOutcomebranch().getId() == this.outcomebranch.getId() && pce.getNewValue() instanceof OutcomebranchUpdatedEvent) {
                    OutcomebranchUpdatedEvent tmp = (OutcomebranchUpdatedEvent)pce.getNewValue();
                    this.outcomebranch.copyFrom(tmp.getOutcomebranch());
                    this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
                }
            } else if (pce.getNewValue() instanceof ExpandOutcomebranch && ((ExpandOutcomebranch)pce.getNewValue()).getOutcomebranch().getId() == this.outcomebranch.getId()) {
                this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
            }
        }
    }

    public boolean hasNodeEditor() {
        return false;
    }

    private class RemoveAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveAction.class, (String)"Generic.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OutcomebranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveOutcomebranchAA(OutcomebranchNode.this.outcomebranch, OutcomebranchNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }
}

