/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.studies;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import metaanalysis.actions.models.DefineComparisonbranchesForAllStudiesAA;
import metaanalysis.actions.models.DefineOutcomebranchesForAllStudiesAA;
import metaanalysis.actions.models.DefineSubgroupbranchesForAllStudiesAA;
import metaanalysis.actions.models.DefineTimepointbranchesForAllStudiesAA;
import metaanalysis.actions.models.SetEffectsizeValueToOutcomebranchAA;
import metaanalysis.analysis.variables.StudyModelVariableStatisticBuilder;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.flavors.ComparisonFlavor;
import metaanalysis.core.flavors.OutcomeFlavor;
import metaanalysis.core.flavors.SubgroupFlavor;
import metaanalysis.core.flavors.TimepointFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.StudyCreatedEvent;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractContainerNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.effectsize.valuesdefinition.ESVFlavor;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.guiandnodes.studies.ComparisonbranchNode;
import metaanalysis.guiandnodes.studies.editors.CreateNewStudyPanel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.PasteType;

public class StudiesContainerNode
extends AbstractContainerNode
implements INodeEditor,
PropertyChangeListener {
    private final StudyModelVariableStatisticBuilder smvs;
    private Topic topic;

    public StudiesContainerNode(Topic topic, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children);
        this.smvs = new StudyModelVariableStatisticBuilder(topic.getId(), applicationEventWorker);
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
        this.topic = topic;
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/study_folder_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/study_folder_iconOpen.png");
    }

    public Action[] getActions(boolean popup) {
        ArrayList<AddStudyAction> actions = new ArrayList<AddStudyAction>();
        actions.add(new AddStudyAction());
        return actions.toArray(new Action[actions.size()]);
    }

    public PasteType getDropType(final Transferable t, int arg1, int arg2) {
        if (t.isDataFlavorSupported(OutcomeFlavor.OUTCOME_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Outcome o = (Outcome)t.getTransferData(OutcomeFlavor.OUTCOME_FLAVOR);
                        if (TuliTuliTools.doYouWantDoABigMistake((String)NbBundle.getMessage(StudiesContainerNode.class, (String)"ApplyToAllStudies.dialog"))) {
                            StudiesContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineOutcomebranchesForAllStudiesAA(StudiesContainerNode.this.topic, o, StudiesContainerNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(TimepointFlavor.TIMEPOINT_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Integer timepointAmount = ComparisonbranchNode.getTimepointAmount(t);
                        if (timepointAmount != null && TuliTuliTools.doYouWantDoABigMistake((String)NbBundle.getMessage(StudiesContainerNode.class, (String)"ApplyToAllStudies.dialog"))) {
                            StudiesContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineTimepointbranchesForAllStudiesAA(StudiesContainerNode.this.topic, timepointAmount.intValue(), StudiesContainerNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ComparisonFlavor.COMPARISON_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Comparison o = (Comparison)t.getTransferData(ComparisonFlavor.COMPARISON_FLAVOR);
                        if (TuliTuliTools.doYouWantDoABigMistake((String)NbBundle.getMessage(StudiesContainerNode.class, (String)"ApplyToAllStudies.dialog"))) {
                            StudiesContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineComparisonbranchesForAllStudiesAA(StudiesContainerNode.this.topic, o, StudiesContainerNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(SubgroupFlavor.SUBGROUP_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Subgroup o = (Subgroup)t.getTransferData(SubgroupFlavor.SUBGROUP_FLAVOR);
                        if (TuliTuliTools.doYouWantDoABigMistake((String)NbBundle.getMessage(StudiesContainerNode.class, (String)"ApplyToAllStudies.dialog"))) {
                            StudiesContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineSubgroupbranchesForAllStudiesAA(StudiesContainerNode.this.topic, o, StudiesContainerNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ESVFlavor.ESV_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        if (TuliTuliTools.doYouWantDoABigMistake((String)NbBundle.getMessage(StudiesContainerNode.class, (String)"ApplyToAllStudies.dialog"))) {
                            IEffectSizeValue es = (IEffectSizeValue)t.getTransferData(ESVFlavor.ESV_FLAVOR);
                            List allOutcomebranchsOfTimepointbranch = StudiesContainerNode.this.applicationEventWorker.getIDataFunction().getAllOutcomebranchsOfTopic(StudiesContainerNode.this.topic.getId());
                            for (Outcomebranch tmp : allOutcomebranchsOfTimepointbranch) {
                                StudiesContainerNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new SetEffectsizeValueToOutcomebranchAA(es, tmp, StudiesContainerNode.this.applicationEventWorker));
                            }
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType p = this.getDropType(t, 0, 0);
        if (p != null) {
            s.add(p);
        }
    }

    public String getHtmlDisplayName() {
        return NbBundle.getMessage(StudiesContainerNode.class, (String)"StudiesContainerNode.displayName");
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof StudyCreatedEvent) {
            this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
        }
    }

    private class AddStudyAction
    extends AbstractAction
    implements Presenter.Popup {
        public AddStudyAction() {
            this.putValue("Name", NbBundle.getMessage(AddStudyAction.class, (String)"AddStudyAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame f = new JFrame();
            f.add(new CreateNewStudyPanel(StudiesContainerNode.this.topic.getId(), StudiesContainerNode.this.applicationEventWorker, f));
            f.setSize(400, 250);
            f.setLocationRelativeTo(null);
            f.setVisible(true);
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/create_icon.png")));
            return x;
        }
    }
}

