/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.studies;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.DefineComparisonbranchesForStudyAA;
import metaanalysis.actions.models.DefineOutcomebranchesForStudyAA;
import metaanalysis.actions.models.DefineSubgroupbranchAA;
import metaanalysis.actions.models.DefineTimepointbranchesForStudyAA;
import metaanalysis.actions.models.MoveModeratorValueToStudyAA;
import metaanalysis.actions.models.RemoveStudyAA;
import metaanalysis.actions.models.SetEffectsizeValueToOutcomebranchAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.flavors.ComparisonFlavor;
import metaanalysis.core.flavors.ModeratorvalueFlavor;
import metaanalysis.core.flavors.OutcomeFlavor;
import metaanalysis.core.flavors.StudyFlavor;
import metaanalysis.core.flavors.SubgroupFlavor;
import metaanalysis.core.flavors.TimepointFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ExpandStudy;
import metaanalysis.core.functionsapi.events.StudyEvents;
import metaanalysis.core.functionsapi.events.StudyUpdatedEvent;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.effectsize.valuesdefinition.ESVFlavor;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.guiandnodes.studies.ComparisonbranchNode;
import metaanalysis.guiandnodes.studies.editors.StudyEditorPanel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class StudyNode
extends AbstractApplicationNode
implements INodeEditor,
PropertyChangeListener {
    private final Study study;

    public StudyNode(Study study, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)study));
        this.study = study;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/study_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/study_iconOpen.png");
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveStudyAA(this.study, this.applicationEventWorker));
    }

    public Transferable clipboardCut() throws IOException {
        Transferable deflt = super.clipboardCut();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(StudyFlavor.STUDY_FLAVOR){

            protected Study getData() {
                return (Study)StudyNode.this.getLookup().lookup(Study.class);
            }
        });
        return added;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable deflt = super.clipboardCopy();
        ExTransferable added = ExTransferable.create((Transferable)deflt);
        added.put(new ExTransferable.Single(StudyFlavor.STUDY_FLAVOR){

            protected Study getData() {
                return (Study)StudyNode.this.getLookup().lookup(Study.class);
            }
        });
        return added;
    }

    public String getDisplayName() {
        return ((Study)this.getLookup().lookup(Study.class)).getName();
    }

    public Action[] getActions(boolean context) {
        return new Action[]{null, new RemoveStudyAction()};
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent")) {
            if (pce.getNewValue() instanceof StudyEvents && ((StudyEvents)pce.getNewValue()).getStudy().getId() == this.study.getId() && pce.getNewValue() instanceof StudyUpdatedEvent) {
                StudyUpdatedEvent tmp = (StudyUpdatedEvent)pce.getNewValue();
                this.study.copyFrom(tmp.getStudy());
                this.setName(this.study.getName());
                this.setDisplayName(this.study.getName());
            }
            if (pce.getNewValue() instanceof ExpandStudy && ((ExpandStudy)pce.getNewValue()).getStudy().getId() == this.study.getId()) {
                this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
            }
        }
    }

    public StudyEditorPanel getNodeEditor() {
        return new StudyEditorPanel(this.study.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    public PasteType getDropType(final Transferable t, int arg1, int arg2) {
        if (t.isDataFlavorSupported(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Moderatorvalue x = (Moderatorvalue)t.getTransferData(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR);
                        StudyNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new MoveModeratorValueToStudyAA(x, StudyNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(SubgroupFlavor.SUBGROUP_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Subgroup subgroup = (Subgroup)t.getTransferData(SubgroupFlavor.SUBGROUP_FLAVOR);
                        StudyNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineSubgroupbranchAA(subgroup.getId(), StudyNode.this.study, StudyNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(OutcomeFlavor.OUTCOME_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Outcome o = (Outcome)t.getTransferData(OutcomeFlavor.OUTCOME_FLAVOR);
                        StudyNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineOutcomebranchesForStudyAA(StudyNode.this.study, o, StudyNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(TimepointFlavor.TIMEPOINT_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Integer timepointAmount = ComparisonbranchNode.getTimepointAmount(t);
                        if (timepointAmount != null) {
                            StudyNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineTimepointbranchesForStudyAA(StudyNode.this.study, timepointAmount.intValue(), StudyNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ComparisonFlavor.COMPARISON_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Comparison o = (Comparison)t.getTransferData(ComparisonFlavor.COMPARISON_FLAVOR);
                        StudyNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineComparisonbranchesForStudyAA(StudyNode.this.study, o, StudyNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ESVFlavor.ESV_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        IEffectSizeValue es = (IEffectSizeValue)t.getTransferData(ESVFlavor.ESV_FLAVOR);
                        List allOutcomebranchsOfTimepointbranch = StudyNode.this.applicationEventWorker.getIDataFunction().getAllOutcomebranchsOfStudy(StudyNode.this.study.getId());
                        for (Outcomebranch tmp : allOutcomebranchsOfTimepointbranch) {
                            StudyNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new SetEffectsizeValueToOutcomebranchAA(es, tmp, StudyNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType p = this.getDropType(t, 0, 0);
        if (p != null) {
            s.add(p);
        }
    }

    private class RemoveStudyAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveStudyAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveStudyAction.class, (String)"RemoveStudyAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StudyNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveStudyAA(StudyNode.this.study, StudyNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }
}

