/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.studies;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalysis.actions.models.DefineComparisonbranchAA;
import metaanalysis.actions.models.DefineOutcomebranchesForSubgroupbranchAA;
import metaanalysis.actions.models.DefineTimepointbranchesForSubgroupbranchAA;
import metaanalysis.actions.models.MoveModeratorValueToSubgroupbranchAA;
import metaanalysis.actions.models.RemoveSubgroupbranchAA;
import metaanalysis.actions.models.SetEffectsizeValueToOutcomebranchAA;
import metaanalysis.core.flavors.ComparisonFlavor;
import metaanalysis.core.flavors.ModeratorvalueFlavor;
import metaanalysis.core.flavors.OutcomeFlavor;
import metaanalysis.core.flavors.TimepointFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ExpandSubgroupbranch;
import metaanalysis.core.functionsapi.events.SubgroupEvents;
import metaanalysis.core.functionsapi.events.SubgroupUpdatedEvent;
import metaanalysis.core.persistence.Comparison;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Subgroup;
import metaanalysis.core.persistence.Subgroupbranch;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.effectsize.valuesdefinition.ESVFlavor;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.guiandnodes.studies.ComparisonbranchNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class SubgroupbranchNode
extends AbstractApplicationNode
implements PropertyChangeListener {
    private final Subgroupbranch subgroupbranch;
    private final Subgroup subgroup;

    public SubgroupbranchNode(Subgroupbranch subgroupbranch, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)subgroupbranch));
        this.subgroupbranch = subgroupbranch;
        this.subgroup = this.applicationEventWorker.getIDataFunction().getSubgroup(this.subgroupbranch.getSubgroupId().intValue());
        this.setDisplayName(this.subgroup.getName());
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/subgroup_link_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/subgroup_link_iconOpen.png");
    }

    public boolean canCut() {
        return true;
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() {
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveSubgroupbranchAA(this.subgroupbranch, this.applicationEventWorker));
    }

    public Action[] getActions(boolean context) {
        return new Action[]{new RemoveAction()};
    }

    public PasteType getDropType(final Transferable t, int arg1, int arg2) {
        if (t.isDataFlavorSupported(ComparisonFlavor.COMPARISON_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Comparison tmp = (Comparison)t.getTransferData(ComparisonFlavor.COMPARISON_FLAVOR);
                        SubgroupbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineComparisonbranchAA(tmp.getId(), SubgroupbranchNode.this.subgroupbranch, SubgroupbranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(OutcomeFlavor.OUTCOME_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Outcome o = (Outcome)t.getTransferData(OutcomeFlavor.OUTCOME_FLAVOR);
                        SubgroupbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineOutcomebranchesForSubgroupbranchAA(SubgroupbranchNode.this.subgroupbranch, o, SubgroupbranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(TimepointFlavor.TIMEPOINT_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Integer timepointAmount = ComparisonbranchNode.getTimepointAmount(t);
                        if (timepointAmount != null) {
                            SubgroupbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineTimepointbranchesForSubgroupbranchAA(SubgroupbranchNode.this.subgroupbranch, timepointAmount.intValue(), SubgroupbranchNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ESVFlavor.ESV_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        IEffectSizeValue es = (IEffectSizeValue)t.getTransferData(ESVFlavor.ESV_FLAVOR);
                        List allOutcomebranchsOfTimepointbranch = SubgroupbranchNode.this.applicationEventWorker.getIDataFunction().getAllOutcomebranchsOfSubgroupbranch(SubgroupbranchNode.this.subgroupbranch.getId());
                        for (Outcomebranch tmp : allOutcomebranchsOfTimepointbranch) {
                            SubgroupbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new SetEffectsizeValueToOutcomebranchAA(es, tmp, SubgroupbranchNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Moderatorvalue x = (Moderatorvalue)t.getTransferData(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR);
                        SubgroupbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new MoveModeratorValueToSubgroupbranchAA(x, SubgroupbranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType p = this.getDropType(t, 0, 0);
        if (p != null) {
            s.add(p);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent")) {
            if (pce.getNewValue() instanceof SubgroupEvents && ((SubgroupEvents)pce.getNewValue()).getSubgroup().getId() == this.subgroup.getId() && pce.getNewValue() instanceof SubgroupUpdatedEvent) {
                SubgroupUpdatedEvent tmp = (SubgroupUpdatedEvent)pce.getNewValue();
                this.subgroup.copyFrom(tmp.getSubgroup());
                this.setName(this.subgroup.getName());
                this.setDisplayName(this.subgroup.getName());
            }
            if (pce.getNewValue() instanceof ExpandSubgroupbranch && ((ExpandSubgroupbranch)pce.getNewValue()).getSubgroupbranch().getId() == this.subgroupbranch.getId()) {
                this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
            }
        }
    }

    private class RemoveAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveAction.class, (String)"Generic.remove"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SubgroupbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveSubgroupbranchAA(SubgroupbranchNode.this.subgroupbranch, SubgroupbranchNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }
}

