/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.studies;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import metaanalysis.actions.models.DefineOutcomebranchAA;
import metaanalysis.actions.models.MoveModeratorValueToTimepointbranchAA;
import metaanalysis.actions.models.SetEffectsizeValueToOutcomebranchAA;
import metaanalysis.core.flavors.ModeratorvalueFlavor;
import metaanalysis.core.flavors.OutcomeFlavor;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.ExpandTimepointbranch;
import metaanalysis.core.persistence.Moderatorvalue;
import metaanalysis.core.persistence.Outcome;
import metaanalysis.core.persistence.Outcomebranch;
import metaanalysis.core.persistence.Timepointbranch;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.effectsize.valuesdefinition.ESVFlavor;
import metaanalysis.effectsizes.models.IEffectSizeValue;
import metaanalysis.events.models.ExpandNode;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class TimepointbranchNode
extends AbstractApplicationNode
implements PropertyChangeListener {
    private final Timepointbranch timepointbranch;

    public TimepointbranchNode(Timepointbranch timepointbranch, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)timepointbranch));
        this.timepointbranch = timepointbranch;
        this.setDisplayName("W" + (this.timepointbranch.getTimepointId() + 1));
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/timepoint_link_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/timepoint_link_iconOpen.png");
    }

    public PasteType getDropType(final Transferable t, int arg1, int arg2) {
        if (t.isDataFlavorSupported(OutcomeFlavor.OUTCOME_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Outcome outcome = (Outcome)t.getTransferData(OutcomeFlavor.OUTCOME_FLAVOR);
                        TimepointbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new DefineOutcomebranchAA(TimepointbranchNode.this.timepointbranch, outcome, TimepointbranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        Moderatorvalue x = (Moderatorvalue)t.getTransferData(ModeratorvalueFlavor.MODERATORVALUE_FLAVOR);
                        TimepointbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new MoveModeratorValueToTimepointbranchAA(x, TimepointbranchNode.this.applicationEventWorker));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        if (t.isDataFlavorSupported(ESVFlavor.ESV_FLAVOR)) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        IEffectSizeValue es = (IEffectSizeValue)t.getTransferData(ESVFlavor.ESV_FLAVOR);
                        List allOutcomebranchsOfTimepointbranch = TimepointbranchNode.this.applicationEventWorker.getIDataFunction().getAllOutcomebranchsOfTimepointbranch(TimepointbranchNode.this.timepointbranch.getId());
                        for (Outcomebranch tmp : allOutcomebranchsOfTimepointbranch) {
                            TimepointbranchNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new SetEffectsizeValueToOutcomebranchAA(es, tmp, TimepointbranchNode.this.applicationEventWorker));
                        }
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType p = this.getDropType(t, 0, 0);
        if (p != null) {
            s.add(p);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof ExpandTimepointbranch && ((ExpandTimepointbranch)pce.getNewValue()).getTimepointbranch().getId() == this.timepointbranch.getId()) {
            this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandNode((Node)this));
        }
    }
}

