/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.studies.childfactory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import metaanalysis.core.entitycomparators.StudyNameComparator;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.StudyCreatedEvent;
import metaanalysis.core.functionsapi.events.StudyDeletedEvent;
import metaanalysis.core.functionsapi.events.StudyEvents;
import metaanalysis.core.persistence.Study;
import metaanalysis.core.persistence.Topic;
import metaanalysis.guiandnodes.studies.StudyNode;
import metaanalysis.guiandnodes.studies.childfactory.TurboChildFactory;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class StudiesContainerChildFactory
extends ChildFactory.Detachable<Study>
implements PropertyChangeListener {
    private final IApplicationManager applicationEventWorker;
    private final Topic topic;

    public StudiesContainerChildFactory(IApplicationManager applicationEventRegister, Topic topic) {
        this.topic = topic;
        this.applicationEventWorker = applicationEventRegister;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
    }

    protected boolean createKeys(List<Study> list) {
        List allStudiesOfTopic = this.applicationEventWorker.getIDataFunction().getAllStudiesOfTopic(this.topic);
        Collections.sort(allStudiesOfTopic, new StudyNameComparator());
        list.addAll(allStudiesOfTopic);
        return true;
    }

    protected Node createNodeForKey(Study key) {
        return new StudyNode(key, this.applicationEventWorker, Children.create((ChildFactory)new TurboChildFactory(key, false, this.applicationEventWorker), (boolean)true));
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof StudyEvents && (pce.getNewValue() instanceof StudyDeletedEvent || pce.getNewValue() instanceof StudyCreatedEvent) && ((StudyEvents)pce.getNewValue()).getStudy().getTopicId().longValue() == this.topic.getId()) {
            this.refresh(true);
        }
    }
}

