/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.guiandnodes.studies.editors;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalsysis.guiutil.guicheckers.StringNotNullRole;
import metaanalysis.actions.models.UpdateStudyAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.StudyEvents;
import metaanalysis.core.persistence.Study;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class StudyEditorPanel
extends AbstractEditorPanel {
    private Study study = null;
    private long studyId;
    private boolean saveButtonActive = false;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel nameLabel;
    private JTextField nameValue;
    private JTextArea noteArea;
    private JButton saveButton;

    public StudyEditorPanel(long studyId, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        super(applicationEventWorker, guiChecker);
        this.studyId = studyId;
        this.initComponents();
        this.reloadAll();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameValue = new JTextField();
        this.saveButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.noteArea = new JTextArea();
        this.nameLabel.setText(NbBundle.getMessage(StudyEditorPanel.class, (String)"StudyEditorPanel.nameLabel.text"));
        this.nameValue.setText(NbBundle.getMessage(StudyEditorPanel.class, (String)"StudyEditorPanel.nameValue.text"));
        this.nameValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                StudyEditorPanel.this.nameValueKeyReleased(evt);
            }
        });
        this.saveButton.setText(NbBundle.getMessage(StudyEditorPanel.class, (String)"StudyEditorPanel.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StudyEditorPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText(NbBundle.getMessage(StudyEditorPanel.class, (String)"StudyEditorPanel.jLabel1.text"));
        this.noteArea.setColumns(20);
        this.noteArea.setLineWrap(true);
        this.noteArea.setRows(5);
        this.jScrollPane1.setViewportView(this.noteArea);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.saveButton).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.nameLabel, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.nameValue, -2, 221, -2)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1))).addContainerGap(39, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameValue, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.saveButton).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 133, -2).addGap(41, 41, 41)));
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.study.setName(this.nameValue.getText());
        this.study.setNote(this.noteArea.getText());
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new UpdateStudyAA(this.study, this.applicationEventWorker));
        try {
            Thread.sleep(TuliTuliTools.waitngTime);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void nameValueKeyReleased(KeyEvent evt) {
        this.guiChecker.fieldChange(this.nameValue);
        this.validate();
    }

    public final void reloadAll() {
        this.guiChecker.svuota();
        this.study = this.applicationEventWorker.getIDataFunction().getStudy(this.studyId);
        if (this.study == null) {
            this.scompari();
        } else {
            this.appari();
            this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.nameValue, this.study.getName()));
            this.guiChecker.checkWhitoutFix();
            this.noteArea.setText(this.study.getNote());
        }
    }

    public boolean readApplicationEvent(IApplicationEvent event) {
        if (event instanceof StudyEvents && ((StudyEvents)event).getStudy().getId() == this.studyId) {
            this.reloadAll();
            return true;
        }
        return false;
    }

    public String getBarTitle() {
        return NbBundle.getMessage(StudyEditorPanel.class, (String)"StudyEditor.barTitle");
    }
}

