/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.models.tables;

import formattazione.numeri.MyNumberFormatter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import metaanalysis.models.tables.ExcelAdapter;
import metaanalysis.models.tables.MyAbstractTableModel;
import metaanalysis.models.tables.cellrenders.MyCellRender;

public abstract class AbstractTable
extends JTable {
    public static Dimension intercellSpacing = new Dimension(5, 5);
    MyAbstractTableModel tm;
    private final MyNumberFormatter myNumberFormatter;

    public AbstractTable(MyAbstractTableModel tm, MyNumberFormatter myNumberFormatter) {
        this(tm, true, false, myNumberFormatter);
    }

    public AbstractTable(MyAbstractTableModel tm, boolean sortable, MyNumberFormatter myNumberFormatter) {
        this(tm, sortable, false, myNumberFormatter);
    }

    public AbstractTable(MyAbstractTableModel tm, boolean sortable, boolean verticalAlign, MyNumberFormatter myNumberFormatter) {
        super(tm);
        KeyListener[] keyListeners;
        this.tm = tm;
        this.myNumberFormatter = myNumberFormatter;
        this.setFillsViewportHeight(true);
        this.setGridColor(Color.GRAY);
        this.setShowGrid(true);
        this.setAutoCreateRowSorter(sortable);
        this.setCellSelectionEnabled(true);
        this.setBorder(new LineBorder(Color.BLACK, 1));
        this.setIntercellSpacing(intercellSpacing);
        TableCellRenderer defaultRenderer = this.getTableHeader().getDefaultRenderer();
        for (KeyListener c : keyListeners = this.getKeyListeners()) {
            this.removeKeyListener(c);
        }
        this.addKeyListener(new ExcelAdapter(this));
    }

    @Override
    public abstract TableCellRenderer getCellRenderer(int var1, int var2);

    public abstract MyCellRender getMyCellRenderer(int var1, int var2);

    @Override
    public String getToolTipText(MouseEvent me) {
        Point p = me.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        TableCellRenderer cellRenderer = this.getCellRenderer(rowIndex, colIndex);
        if (cellRenderer instanceof MyCellRender) {
            return ((MyCellRender)cellRenderer).toToolTip(this.getValueAt(rowIndex, colIndex));
        }
        return "";
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Object tip = null;
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                String[] headersToolType = AbstractTable.this.tm.getHeadersToolType();
                return headersToolType[realIndex];
            }
        };
    }

    public MyAbstractTableModel getTm() {
        return this.tm;
    }

    public MyNumberFormatter getMyNumberFormatter() {
        return this.myNumberFormatter;
    }
}

