/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.models.tables;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import metaanalysis.models.tables.AbstractTable;
import metaanalysis.models.tables.cellrenders.MyCellRender;

public class ExcelAdapter
extends KeyAdapter {
    private static final String LINE_BREAK = "\n";
    private static final String CELL_BREAK = "\t";
    private static final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final AbstractTable table;

    public ExcelAdapter(AbstractTable table) {
        this.table = table;
    }

    @Override
    public void keyReleased(KeyEvent event) {
        if ((event.isControlDown() || event.isMetaDown()) && (event.getKeyCode() == 67 || event.getKeyCode() == 88)) {
            this.cancelEditing();
            this.copyToClipboard(false);
        }
    }

    private void copyToClipboard(boolean isCut) {
        int numCols = this.table.getSelectedColumnCount();
        int numRows = this.table.getSelectedRowCount();
        int[] rowsSelected = this.table.getSelectedRows();
        int[] colsSelected = this.table.getSelectedColumns();
        StringBuilder excelStr = new StringBuilder();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                Object valueAt = this.table.getValueAt(rowsSelected[i], colsSelected[j]);
                MyCellRender cellRenderer = this.table.getMyCellRenderer(i, j);
                String toClipboard = cellRenderer.toClipboard(valueAt);
                String escape = this.escape(toClipboard);
                excelStr.append(escape);
                if (j >= numCols - 1) continue;
                excelStr.append(CELL_BREAK);
            }
            excelStr.append(LINE_BREAK);
        }
        StringSelection sel = new StringSelection(excelStr.toString());
        CLIPBOARD.setContents(sel, sel);
    }

    private void cancelEditing() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().cancelCellEditing();
        }
    }

    private String escape(Object cell) {
        return cell.toString().replace(LINE_BREAK, " ").replace(CELL_BREAK, " ");
    }
}

