/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.models.tables;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import metaanalysis.models.tables.MyTableHeaderRenderer;

public class TableFunctions {
    public static void showToolTips(final JTable t) {
        t.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point p = e.getPoint();
                int row = t.rowAtPoint(p);
                int column = t.columnAtPoint(p);
                t.setToolTipText(String.valueOf(t.getValueAt(row, column)));
            }
        });
    }

    public static void centerHeaders(JTable t) {
        Enumeration<TableColumn> columns = t.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            columns.nextElement().setHeaderRenderer(new MyTableHeaderRenderer());
        }
    }

    public static void addPopUpMenu(final JTable table) {
        JMenuItem menuItem = new JMenuItem("MENU");
        table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent me) {
            }

            @Override
            public void mousePressed(MouseEvent me) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int r = table.rowAtPoint(e.getPoint());
                if (r >= 0 && r < table.getRowCount()) {
                    table.setRowSelectionInterval(r, r);
                } else {
                    table.clearSelection();
                }
                int rowindex = table.getSelectedRow();
                if (rowindex < 0) {
                    return;
                }
                if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                    JPopupMenu popup = new JPopupMenu("Casaa");
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
            }

            @Override
            public void mouseExited(MouseEvent me) {
            }
        });
    }
}

