/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.models.tables.cellrenders;

import formattazione.numeri.MyNumberFormatter;
import metaanalysis.models.tables.cellrenders.MyCellRender;

public class IntegerCellRender
extends MyCellRender {
    public IntegerCellRender(MyNumberFormatter myNumberFormatter) {
        super(myNumberFormatter);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue("");
        } else if (value instanceof Integer) {
            super.setValue(this.myNumberFormatter.formatInLang(((Integer)value).intValue()));
        } else {
            super.setValue("");
        }
    }

    @Override
    public String toToolTip(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Integer) {
            return this.myNumberFormatter.formatInLang(((Integer)value).intValue());
        }
        return "";
    }

    @Override
    public String toClipboard(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Integer) {
            return this.myNumberFormatter.formatInLang(((Integer)value).intValue());
        }
        return "";
    }
}

