/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.models.tables.cellrenders;

import formattazione.numeri.MyNumberFormatter;
import metaanalysis.models.tables.cellrenders.MyCellRender;

public class WeightCellRender
extends MyCellRender {
    public WeightCellRender(MyNumberFormatter myNumberFormatter) {
        super(myNumberFormatter);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue("");
        } else if (value instanceof Double) {
            super.setValue(this.myNumberFormatter.formatDouble(Double.valueOf((Double)value), 2) + "%");
        } else {
            super.setValue("");
        }
    }

    @Override
    public String toToolTip(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Double) {
            return this.myNumberFormatter.formatInLang(((Double)value).doubleValue());
        }
        return "";
    }

    @Override
    public String toClipboard(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Double) {
            return this.myNumberFormatter.formatInLang((Double)value / 100.0);
        }
        return "";
    }
}

