/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.application.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalysis.actions.models.CloneTopicAA;
import metaanalysis.actions.models.RemoveTopicAA;
import metaanalysis.application.standardexplorer.TopicEditorPanel;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.TopicEvents;
import metaanalysis.core.functionsapi.events.TopicUpdatedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractApplicationNode;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.dataeditor.models.INodeEditor;
import metaanalysis.events.models.ExpandAll;
import metaanalysis.events.models.IApplicationEvent;
import metaanalysis.util.backup.BackupBean;
import metaanalysis.util.backup.BackupException;
import metaanalysis.util.backup.BackupFunctions;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class TopicNode
extends AbstractApplicationNode
implements PropertyChangeListener,
INodeEditor {
    private final Topic topic;

    public TopicNode(Topic topic, IApplicationManager applicationEventWorker, Children children) {
        super(applicationEventWorker, children, Lookups.singleton((Object)topic));
        this.topic = topic;
        this.applicationEventWorker.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.applicationEventWorker));
        this.setDisplayName(this.topic.getName());
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/topic_icon.png");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"metaanalysis/application/style/topic_iconOpen.png");
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent") && pce.getNewValue() instanceof TopicEvents && ((TopicEvents)pce.getNewValue()).getTopic().getId() == this.topic.getId() && pce.getNewValue() instanceof TopicUpdatedEvent) {
            TopicUpdatedEvent tmp = (TopicUpdatedEvent)pce.getNewValue();
            this.topic.copyFrom(tmp.getTopic());
            this.setName(this.topic.getName());
            this.setDisplayName(this.topic.getName());
        }
    }

    public Action[] getActions(boolean popup) {
        ArrayList<ExpandMyself> actions = new ArrayList<ExpandMyself>();
        actions.add(new ExpandMyself((Node)this));
        return actions.toArray(new Action[actions.size()]);
    }

    public AbstractEditorPanel getNodeEditor() {
        return new TopicEditorPanel(this.topic.getId(), this.applicationEventWorker, new GuiChecker(this.applicationEventWorker.getEditorPanelsUndoRedoManager(), TuliTuliTools.isAutoSelectContentFieldEnabled()));
    }

    private class CloneTopicAction
    extends AbstractAction
    implements Presenter.Popup {
        public CloneTopicAction() {
            this.putValue("Name", NbBundle.getMessage(CloneTopicAction.class, (String)"TopicNode.CloneTopicAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TopicNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new CloneTopicAA(TopicNode.this.topic, TopicNode.this.applicationEventWorker));
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/clone_icon.png")));
            return x;
        }
    }

    private class FastBackupAction
    extends AbstractAction
    implements Presenter.Popup {
        public FastBackupAction() {
            this.putValue("Name", NbBundle.getMessage(FastBackupAction.class, (String)"TopicNode.FastBackupAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                BackupBean backupBean = new BackupBean(TopicNode.this.topic.getId(), TopicNode.this.applicationEventWorker.getIDataFunction());
                backupBean.fastBackup();
                TuliTuliTools.whatAMessage((String)NbBundle.getMessage(TopicNode.class, (String)"backup.completed"));
            }
            catch (BackupException ex) {
                TuliTuliTools.whatAnError((String)ex.getMessage());
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/export_icon.png")));
            return x;
        }
    }

    private class ExportTopicAction
    extends AbstractAction
    implements Presenter.Popup {
        public ExportTopicAction() {
            this.putValue("Name", NbBundle.getMessage(ExportTopicAction.class, (String)"TopicNode.ExportTopicAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                BackupFunctions.exportTopicToFile((Topic)TopicNode.this.topic, (IApplicationManager)TopicNode.this.applicationEventWorker);
                TuliTuliTools.whatAMessage((String)NbBundle.getMessage(BackupFunctions.class, (String)"export.completed"));
            }
            catch (BackupException ex) {
                TuliTuliTools.whatAnError((String)ex.getMessage());
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/export_icon.png")));
            return x;
        }
    }

    private class RemoveTopicAction
    extends AbstractAction
    implements Presenter.Popup {
        public RemoveTopicAction() {
            this.putValue("Name", NbBundle.getMessage(RemoveTopicAction.class, (String)"TopicNode.RemoveTopicAction.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TuliTuliTools.doYouWantDoABigMistake((String)NbBundle.getMessage(RemoveTopicAction.class, (String)"TopicNode.RemoveTopicAction.descriptionDialog"))) {
                TopicNode.this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new RemoveTopicAA(TopicNode.this.topic, TopicNode.this.applicationEventWorker));
            }
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/delete_icon.png")));
            return x;
        }
    }

    private class ExpandMyself
    extends AbstractAction
    implements Presenter.Popup {
        private Node n;

        public ExpandMyself(Node n) {
            this.n = n;
            this.putValue("Name", NbBundle.getMessage(ExpandMyself.class, (String)"TopicNode.ExpandMyself.actionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TopicNode.this.applicationEventWorker.setApplicationEvent((IApplicationEvent)new ExpandAll());
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem x = new JMenuItem(this);
            x.setIcon(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"metaanalysis/application/style/expand_icon.png")));
            return x;
        }
    }
}

