/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.application.standardexplorer;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import metaanalysis.application.childfactory.TopicsContainerChildFactory;
import metaanalysis.application.nodes.TopicsContainerNode;
import metaanalysis.application.style.StyleProvider;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.TopicUpdatedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.events.models.ExpandAll;
import metaanalysis.events.models.ExpandNode;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="MainExplorerWindowTopComponent", iconBase="metaanalysis/application/style/database_tree_icon.png", persistenceType=0)
public final class MainExplorerWindowTopComponent
extends TopComponent
implements PropertyChangeListener,
ExplorerManager.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();
    protected BeanTreeView albero = new BeanTreeView();
    protected Node topicNode;
    private JScrollPane jScrollPane1;

    public MainExplorerWindowTopComponent() {
        this.initComponents();
        this.jScrollPane1.setBackground(StyleProvider.panelBackground);
        this.albero.setBackground(StyleProvider.panelBackground);
        ((IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class)).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)Lookup.getDefault().lookup(IApplicationManager.class)));
        this.setName(NbBundle.getMessage(MainExplorerWindowTopComponent.class, (String)"CTL_MainExplorerWindowTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MainExplorerWindowTopComponent.class, (String)"HINT_MainExplorerWindowTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.closing_disabled", Boolean.TRUE);
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)false));
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)map));
        Date xxx = new Date();
        this.topicNode = new TopicsContainerNode((IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class), Children.create((ChildFactory)new TopicsContainerChildFactory((IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class)), (boolean)true));
        this.explorerManager.setRootContext(this.topicNode);
        this.albero.setRootVisible(false);
    }

    private void initComponents() {
        this.jScrollPane1 = this.albero;
        this.setLayout(new BorderLayout());
        this.add(this.jScrollPane1, "Center");
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public UndoRedo.Manager getUndoRedo() {
        return ((IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class)).getMainUndoRedoManager();
    }

    public HelpCtx getHelpCtx() {
        Node[] selectedNodes = this.explorerManager.getSelectedNodes();
        if (selectedNodes.length < 1) {
            return super.getHelpCtx();
        }
        return selectedNodes[0].getHelpCtx();
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getPropertyName().equals("applicationEvent")) {
            if (pce.getNewValue() instanceof TopicUpdatedEvent) {
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        IApplicationManager iApplicationManager = (IApplicationManager)Lookup.getDefault().lookup(IApplicationManager.class);
                        List allOpenedTopics = iApplicationManager.getIDataFunction().getAllOpenedTopics();
                        if (!allOpenedTopics.isEmpty()) {
                            WindowManager.getDefault().getMainWindow().setTitle("ProMeta - " + ((Topic)allOpenedTopics.get(0)).getName());
                        } else {
                            WindowManager.getDefault().getMainWindow().setTitle("ProMeta");
                        }
                    }
                });
            } else if (pce.getNewValue() instanceof ExpandAll) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainExplorerWindowTopComponent.this.albero.expandAll();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MainExplorerWindowTopComponent.this.albero.expandAll();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        MainExplorerWindowTopComponent.this.albero.expandAll();
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                MainExplorerWindowTopComponent.this.albero.expandAll();
                                                SwingUtilities.invokeLater(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        MainExplorerWindowTopComponent.this.albero.expandAll();
                                                        SwingUtilities.invokeLater(new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                MainExplorerWindowTopComponent.this.albero.expandAll();
                                                            }
                                                        });
                                                    }
                                                });
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            } else if (pce.getNewValue() instanceof ExpandNode) {
                final Node node = ((ExpandNode)pce.getNewValue()).getNode();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainExplorerWindowTopComponent.this.albero.expandNode(node);
                    }
                });
            }
        }
    }
}

