/*
 * Decompiled with CFR 0.152.
 */
package metaanalysis.application.standardexplorer;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import metaanalsysis.guiutil.guicheckers.AbstractRole;
import metaanalsysis.guiutil.guicheckers.GuiChecker;
import metaanalsysis.guiutil.guicheckers.StringNotNullRole;
import metaanalysis.actions.models.UpdateTopicAA;
import metaanalysis.application.tools.TuliTuliTools;
import metaanalysis.core.functionsapi.IApplicationActionModel;
import metaanalysis.core.functionsapi.IApplicationManager;
import metaanalysis.core.functionsapi.events.TopicDeletedEvent;
import metaanalysis.core.functionsapi.events.TopicEvents;
import metaanalysis.core.functionsapi.events.TopicOpenedEvent;
import metaanalysis.core.functionsapi.events.TopicUpdatedEvent;
import metaanalysis.core.persistence.Topic;
import metaanalysis.dataeditor.models.AbstractEditorPanel;
import metaanalysis.events.models.IApplicationEvent;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TopicEditorPanel
extends AbstractEditorPanel {
    private Topic topic;
    private final long topicId;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel nameLabel;
    private JTextField nameValue;
    private JTextArea noteArea;
    private JButton saveButton;

    public TopicEditorPanel(long topicId, IApplicationManager applicationEventWorker, GuiChecker guiChecker) {
        super(applicationEventWorker, guiChecker);
        this.initComponents();
        this.topicId = topicId;
        this.reloadAll();
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameValue = new JTextField();
        this.saveButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.noteArea = new JTextArea();
        this.nameLabel.setText(NbBundle.getMessage(TopicEditorPanel.class, (String)"TopicEditorPanel.nameLabel.text_1"));
        this.nameValue.setText(NbBundle.getMessage(TopicEditorPanel.class, (String)"TopicEditorPanel.nameValue.text_1"));
        this.nameValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                TopicEditorPanel.this.nameValueKeyReleased(evt);
            }
        });
        this.saveButton.setText(NbBundle.getMessage(TopicEditorPanel.class, (String)"TopicEditorPanel.saveButton.text"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TopicEditorPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText(NbBundle.getMessage(TopicEditorPanel.class, (String)"TopicEditorPanel.jLabel1.text"));
        this.noteArea.setColumns(20);
        this.noteArea.setLineWrap(true);
        this.noteArea.setRows(5);
        this.jScrollPane1.setViewportView(this.noteArea);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.saveButton).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel, -2, 58, -2).addGap(18, 18, 18).addComponent(this.nameValue, -2, 200, -2))).addComponent(this.jLabel1))).addContainerGap(59, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameValue, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.saveButton).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 120, -2).addContainerGap(40, Short.MAX_VALUE)));
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.topic.setName(this.nameValue.getText());
        this.topic.setNote(this.noteArea.getText());
        this.applicationEventWorker.getApplicationActionHandler().runAction((IApplicationActionModel)new UpdateTopicAA(this.topic, this.applicationEventWorker));
        try {
            Thread.sleep(TuliTuliTools.waitngTime);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void nameValueKeyReleased(KeyEvent evt) {
        this.guiChecker.fieldChange(this.nameValue);
        this.validate();
    }

    public final void reloadAll() {
        this.topic = this.applicationEventWorker.getIDataFunction().getTopic(this.topicId);
        this.guiChecker.svuota();
        this.noteArea.setText(this.topic.getNote());
        this.guiChecker.getEligibleObjects().add(this.saveButton);
        this.guiChecker.addRole((AbstractRole)new StringNotNullRole(this.nameValue, this.topic.getName()));
        this.nameValue.setText(this.topic.getName());
    }

    public boolean readApplicationEvent(IApplicationEvent event) {
        if (event instanceof TopicEvents) {
            if (event instanceof TopicOpenedEvent || event instanceof TopicDeletedEvent) {
                this.scompari();
            } else if (((TopicEvents)event).getTopic().getId() == this.topic.getId() && event instanceof TopicUpdatedEvent) {
                this.reloadAll();
            }
            return true;
        }
        return false;
    }

    public String getBarTitle() {
        return NbBundle.getMessage(TopicEditorPanel.class, (String)"TopicEditorPanel.barTitle");
    }
}

