/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.Marshallable;

@Marshallable(externalizer=Externalizer.class, id=16)
public class TransientCacheValue
extends ImmortalCacheValue {
    long maxIdle = -1L;
    long lastUsed;

    TransientCacheValue(Object value, long maxIdle, long lastUsed) {
        super(value);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    @Override
    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    @Override
    public final boolean isExpired() {
        return ExpiryHelper.isExpiredTransient(this.maxIdle, this.lastUsed);
    }

    @Override
    public boolean canExpire() {
        return true;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new TransientCacheEntry(key, this.value, this.maxIdle, this.lastUsed);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransientCacheValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransientCacheValue that = (TransientCacheValue)o;
        if (this.lastUsed != that.lastUsed) {
            return false;
        }
        return this.maxIdle == that.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "TransientCacheValue{maxIdle=" + this.maxIdle + ", lastUsed=" + this.lastUsed + "} " + super.toString();
    }

    @Override
    public TransientCacheValue clone() {
        return (TransientCacheValue)super.clone();
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            TransientCacheValue icv = (TransientCacheValue)subject;
            output.writeObject(icv.value);
            UnsignedNumeric.writeUnsignedLong(output, icv.lastUsed);
            output.writeLong(icv.maxIdle);
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            Long maxIdle = input.readLong();
            return new TransientCacheValue(v, maxIdle, lastUsed);
        }
    }
}

