/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.infinispan.distribution.ch.AbstractWheelConsistentHash;
import org.infinispan.distribution.ch.NodeTopologyInfo;
import org.infinispan.distribution.ch.TopologyInfo;
import org.infinispan.marshall.Marshallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.hash.Hash;

@Marshallable(externalizer=Externalizer.class, id=61)
public class TopologyAwareConsistentHash
extends AbstractWheelConsistentHash {
    public TopologyAwareConsistentHash() {
    }

    public TopologyAwareConsistentHash(Hash hash) {
        this.setHashFunction(hash);
    }

    @Override
    public List<Address> locate(Object key, int replCount) {
        Address owner = this.getOwner(key);
        int ownerCount = Math.min(replCount, this.addresses.size());
        return this.getOwners(owner, ownerCount);
    }

    @Override
    public List<Address> getStateProvidersOnLeave(Address leaver, int replCount) {
        HashSet<Address> result = new HashSet<Address>();
        for (Address address : this.addresses) {
            if (address.equals(leaver) || !this.getOwners(address, replCount).contains(leaver)) continue;
            result.add(address);
        }
        List<Address> addressList = this.getOwners(leaver, replCount);
        if (addressList.size() > 1) {
            result.add(addressList.get(1));
        }
        return new ArrayList<Address>(result);
    }

    @Override
    public List<Address> getStateProvidersOnJoin(Address joiner, int replCount) {
        return this.getStateProvidersOnLeave(joiner, replCount);
    }

    private List<Address> getOwners(Address address, int numOwners) {
        int ownerHash = this.getNormalizedHash(address);
        Collection beforeOnWheel = this.positions.headMap(ownerHash).values();
        Collection afterOnWheel = this.positions.tailMap(ownerHash).values();
        ArrayList processSequence = new ArrayList(afterOnWheel);
        processSequence.addAll(beforeOnWheel);
        ArrayList<Address> result = new ArrayList<Address>();
        result.add((Address)processSequence.remove(0));
        int level = 0;
        while (result.size() < numOwners) {
            Iterator addrIt = processSequence.iterator();
            while (addrIt.hasNext()) {
                Address a = (Address)addrIt.next();
                switch (level) {
                    case 0: {
                        if (this.topologyInfo.isSameSite(address, a)) break;
                        result.add(a);
                        addrIt.remove();
                        break;
                    }
                    case 1: {
                        if (this.topologyInfo.isSameRack(address, a)) break;
                        result.add(a);
                        addrIt.remove();
                        break;
                    }
                    case 2: {
                        if (this.topologyInfo.isSameMachine(address, a)) break;
                        result.add(a);
                        addrIt.remove();
                        break;
                    }
                    case 3: {
                        result.add(a);
                        addrIt.remove();
                    }
                }
                if (result.size() != numOwners) continue;
                break;
            }
            ++level;
        }
        if (result.size() != numOwners) {
            throw new AssertionError((Object)"This should not happen!");
        }
        return result;
    }

    private Address getOwner(Object key) {
        int hash = this.getNormalizedHash(key);
        SortedMap map = this.positions.tailMap(hash);
        if (map.size() == 0) {
            return (Address)this.positions.get(this.positions.firstKey());
        }
        Integer ownerHash = map.firstKey();
        return (Address)this.positions.get(ownerHash);
    }

    public static class Externalizer
    extends AbstractWheelConsistentHash.Externalizer {
        @Override
        protected AbstractWheelConsistentHash instance() {
            return new TopologyAwareConsistentHash();
        }

        @Override
        public void writeObject(ObjectOutput output, Object subject) throws IOException {
            super.writeObject(output, subject);
            TopologyAwareConsistentHash dch = (TopologyAwareConsistentHash)subject;
            Collection<NodeTopologyInfo> infoCollection = dch.topologyInfo.getAllTopologyInfo();
            output.writeInt(infoCollection.size());
            for (NodeTopologyInfo nti : infoCollection) {
                output.writeObject(nti);
            }
        }

        @Override
        public Object readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            TopologyAwareConsistentHash ch = (TopologyAwareConsistentHash)super.readObject(unmarshaller);
            ch.topologyInfo = new TopologyInfo();
            int ntiCount = unmarshaller.readInt();
            for (int i = 0; i < ntiCount; ++i) {
                NodeTopologyInfo nti = (NodeTopologyInfo)unmarshaller.readObject();
                ch.topologyInfo.addNodeTopologyInfo(nti.getAddress(), nti);
            }
            return ch;
        }
    }
}

