/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.jmx.AbstractJmxRegistration;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.JmxDomainConflictException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SurvivesRestarts
public class CacheJmxRegistration
extends AbstractJmxRegistration {
    private static final Log log = LogFactory.getLog(CacheJmxRegistration.class);
    public static final String CACHE_JMX_GROUP = "type=Cache";
    private AdvancedCache cache;
    private Set<AbstractComponentRegistry.Component> nonCacheComponents;

    @Inject
    public void initialize(Cache cache, GlobalConfiguration globalConfig) {
        this.cache = cache.getAdvancedCache();
        this.globalConfig = globalConfig;
    }

    @Start(priority=14)
    public void start() {
        if (this.cache == null) {
            throw new IllegalStateException("The cache should had been injected before a call to this method");
        }
        Configuration config = this.cache.getConfiguration();
        if (config.isExposeJmxStatistics()) {
            Set<AbstractComponentRegistry.Component> components = this.cache.getComponentRegistry().getRegisteredComponents();
            this.nonCacheComponents = this.getNonCacheComponents(components);
            this.registerMBeans(components, this.cache.getConfiguration().getGlobalConfiguration());
            log.info("MBeans were successfully registered to the platform mbean server.");
        }
    }

    @Stop
    public void stop() {
        if (this.cache == null) {
            return;
        }
        Configuration config = this.cache.getConfiguration();
        if (config.isExposeJmxStatistics()) {
            try {
                this.unregisterMBeans(this.nonCacheComponents);
            }
            catch (Exception e) {
                log.warn((Object)"Problems un-registering MBeans", e);
            }
            log.trace("MBeans were successfully unregistered from the mbean server.");
        }
    }

    public void unregisterCacheMBean() {
        String pattern = this.jmxDomain + ":" + CACHE_JMX_GROUP + ",*";
        try {
            Set<ObjectName> names = this.mBeanServer.queryNames(new ObjectName(pattern), null);
            for (ObjectName name : names) {
                this.mBeanServer.unregisterMBean(name);
            }
        }
        catch (MBeanRegistrationException e) {
            String message = "Unable to unregister Cache MBeans with pattern " + pattern;
            log.warn((Object)message, e);
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MalformedObjectNameException e) {
            String message = "Malformed pattern " + pattern;
            log.error((Object)message, e);
            throw new CacheException(message, e);
        }
    }

    @Override
    protected ComponentsJmxRegistration buildRegistrar(Set<AbstractComponentRegistry.Component> components) {
        String groupName = "type=Cache," + ComponentsJmxRegistration.NAME_KEY + "=" + ObjectName.quote(this.cache.getName() + "(" + this.cache.getConfiguration().getCacheModeString().toLowerCase() + ")") + ",manager=" + ObjectName.quote(this.cache.getConfiguration().getGlobalConfiguration().getCacheManagerName());
        ComponentsJmxRegistration registrar = new ComponentsJmxRegistration(this.mBeanServer, components, groupName);
        this.updateDomain(registrar, this.cache.getComponentRegistry().getGlobalComponentRegistry(), this.mBeanServer, groupName);
        return registrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDomain(ComponentsJmxRegistration registrar, GlobalComponentRegistry componentRegistry, MBeanServer mBeanServer, String groupName) {
        GlobalConfiguration gc = componentRegistry.getComponent(GlobalConfiguration.class);
        CacheManagerJmxRegistration managerJmxReg = componentRegistry.getComponent(CacheManagerJmxRegistration.class);
        if (!gc.isExposeGlobalJmxStatistics() && this.jmxDomain == null) {
            String tmpJmxDomain = this.getJmxDomain(gc.getJmxDomain(), mBeanServer, groupName);
            CacheManagerJmxRegistration cacheManagerJmxRegistration = managerJmxReg;
            synchronized (cacheManagerJmxRegistration) {
                if (managerJmxReg.jmxDomain == null) {
                    if (!tmpJmxDomain.equals(gc.getJmxDomain()) && !gc.isAllowDuplicateDomains()) {
                        String message = "There's already an cache manager instance registered under '" + gc.getJmxDomain() + "' JMX domain. If you want to allow multiple instances configured with same JMX domain enable " + "'allowDuplicateDomains' attribute in 'globalJmxStatistics' config element";
                        if (log.isErrorEnabled()) {
                            log.error(message);
                        }
                        throw new JmxDomainConflictException(message);
                    }
                    managerJmxReg.jmxDomain = tmpJmxDomain;
                }
                this.jmxDomain = managerJmxReg.jmxDomain;
            }
        } else {
            this.jmxDomain = managerJmxReg.jmxDomain == null ? gc.getJmxDomain() : managerJmxReg.jmxDomain;
        }
        registrar.setJmxDomain(this.jmxDomain);
    }

    protected Set<AbstractComponentRegistry.Component> getNonCacheComponents(Set<AbstractComponentRegistry.Component> components) {
        HashSet<AbstractComponentRegistry.Component> componentsExceptCache = new HashSet<AbstractComponentRegistry.Component>();
        for (AbstractComponentRegistry.Component component : components) {
            String name = component.getName();
            if (name.equals(Cache.class.getName()) || name.equals(AdvancedCache.class.getName())) continue;
            componentsExceptCache.add(component);
        }
        return componentsExceptCache;
    }
}

