/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.transaction.xa.LocalTransaction;
import org.infinispan.transaction.xa.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionXaAdapter
implements XAResource {
    private static final Log log = LogFactory.getLog(TransactionXaAdapter.class);
    private static boolean trace = log.isTraceEnabled();
    private int txTimeout;
    private final InvocationContextContainer icc;
    private final InterceptorChain invoker;
    private final CommandsFactory commandsFactory;
    private final Configuration configuration;
    private final TransactionTable txTable;
    private final LocalTransaction localTransaction;

    public TransactionXaAdapter(LocalTransaction localTransaction, TransactionTable txTable, CommandsFactory commandsFactory, Configuration configuration, InterceptorChain invoker, InvocationContextContainer icc) {
        this.localTransaction = localTransaction;
        this.txTable = txTable;
        this.commandsFactory = commandsFactory;
        this.configuration = configuration;
        this.invoker = invoker;
        this.icc = icc;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        LocalTransaction localTransaction = this.getLocalTransactionAndValidate(xid);
        this.validateNotMarkedForRollback(localTransaction);
        if (this.configuration.isOnePhaseCommit()) {
            if (trace) {
                log.trace((Object)"Received prepare for tx: {0}. Skipping call as 1PC will be used.", xid);
            }
            return 0;
        }
        PrepareCommand prepareCommand = this.commandsFactory.buildPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), this.configuration.isOnePhaseCommit());
        if (trace) {
            log.trace("Sending prepare command through the chain: " + prepareCommand);
        }
        LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
        ctx.setLocalTransaction(localTransaction);
        try {
            this.invoker.invoke(ctx, prepareCommand);
            if (localTransaction.isReadOnly()) {
                if (trace) {
                    log.trace("Readonly transaction: " + localTransaction.getGlobalTransaction());
                }
                this.commit(xid, false);
                return 3;
            }
            return 0;
        }
        catch (Throwable e) {
            log.error((Object)"Error while processing PrepareCommand", e);
            throw new XAException(-3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean isOnePhase) throws XAException {
        block10: {
            LocalTransaction localTransaction = this.getLocalTransactionAndValidate(xid);
            if (trace) {
                log.trace("committing transaction {0}" + localTransaction.getGlobalTransaction());
            }
            try {
                LocalTxInvocationContext ctx = this.icc.createTxInvocationContext();
                ctx.setLocalTransaction(localTransaction);
                if (this.configuration.isOnePhaseCommit() || isOnePhase) {
                    this.validateNotMarkedForRollback(localTransaction);
                    if (trace) {
                        log.trace("Doing an 1PC prepare call on the interceptor chain");
                    }
                    PrepareCommand command = this.commandsFactory.buildPrepareCommand(localTransaction.getGlobalTransaction(), localTransaction.getModifications(), true);
                    try {
                        this.invoker.invoke(ctx, command);
                        break block10;
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error while processing 1PC PrepareCommand", e);
                        throw new XAException(-3);
                    }
                }
                CommitCommand commitCommand = this.commandsFactory.buildCommitCommand(localTransaction.getGlobalTransaction());
                try {
                    this.invoker.invoke(ctx, commitCommand);
                }
                catch (Throwable e) {
                    log.error((Object)"Error while processing 1PC PrepareCommand", e);
                    throw new XAException(-3);
                }
            }
            finally {
                this.cleanup(localTransaction);
            }
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        TransactionXaAdapter.rollbackImpl(xid, this.commandsFactory, this.icc, this.invoker, this.txTable);
    }

    public static void rollbackImpl(Xid xid, CommandsFactory commandsFactory, InvocationContextContainer icc, InterceptorChain invoker, TransactionTable txTable) throws XAException {
        LocalTransaction localTransaction = TransactionXaAdapter.getLocalTransactionAndValidateImpl(xid, txTable);
        if (trace) {
            log.trace((Object)"rollback transaction {0} ", localTransaction.getGlobalTransaction());
        }
        RollbackCommand rollbackCommand = commandsFactory.buildRollbackCommand(localTransaction.getGlobalTransaction());
        LocalTxInvocationContext ctx = icc.createTxInvocationContext();
        ctx.setLocalTransaction(localTransaction);
        try {
            invoker.invoke(ctx, rollbackCommand);
        }
        catch (Throwable e) {
            log.error((Object)"Exception while rollback", e);
            throw new XAException(8);
        }
        finally {
            TransactionXaAdapter.cleanupImpl(localTransaction, txTable, icc);
        }
    }

    private LocalTransaction getLocalTransactionAndValidate(Xid xid) throws XAException {
        return TransactionXaAdapter.getLocalTransactionAndValidateImpl(xid, this.txTable);
    }

    private static LocalTransaction getLocalTransactionAndValidateImpl(Xid xid, TransactionTable txTable) throws XAException {
        LocalTransaction localTransaction = txTable.getLocalTransaction(xid);
        if (localTransaction == null) {
            if (trace) {
                log.trace((Object)"no tx found for {0}", xid);
            }
            throw new XAException(-4);
        }
        return localTransaction;
    }

    @Override
    public void start(Xid xid, int i) throws XAException {
        this.localTransaction.setXid(xid);
        this.txTable.addLocalTransactionMapping(this.localTransaction);
        if (trace) {
            log.trace("start called on tx " + this.localTransaction.getGlobalTransaction());
        }
    }

    @Override
    public void end(Xid xid, int i) throws XAException {
        if (trace) {
            log.trace("end called on tx " + this.localTransaction.getGlobalTransaction());
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (trace) {
            log.trace("forget called");
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (trace) {
            log.trace("start called");
        }
        return this.txTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (!(xaResource instanceof TransactionXaAdapter)) {
            return false;
        }
        TransactionXaAdapter other = (TransactionXaAdapter)xaResource;
        return other.equals(this);
    }

    @Override
    public Xid[] recover(int i) throws XAException {
        if (trace) {
            log.trace("recover called: " + i);
        }
        return null;
    }

    @Override
    public boolean setTransactionTimeout(int i) throws XAException {
        this.txTimeout = i;
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionXaAdapter)) {
            return false;
        }
        TransactionXaAdapter that = (TransactionXaAdapter)o;
        return this.localTransaction.equals(that.localTransaction);
    }

    public int hashCode() {
        return this.localTransaction.getGlobalTransaction().hashCode();
    }

    public String toString() {
        return "TransactionXaAdapter{localTransaction=" + this.localTransaction + '}';
    }

    private void validateNotMarkedForRollback(LocalTransaction localTransaction) throws XAException {
        if (localTransaction.isMarkedForRollback()) {
            if (trace) {
                log.trace((Object)"Transaction already marked for rollback: {0}", localTransaction);
            }
            throw new XAException(100);
        }
    }

    private void cleanup(LocalTransaction localTransaction) {
        TransactionXaAdapter.cleanupImpl(localTransaction, this.txTable, this.icc);
    }

    private static void cleanupImpl(LocalTransaction localTransaction, TransactionTable txTable, InvocationContextContainer icc) {
        txTable.removeLocalTransaction(localTransaction);
        icc.suspend();
    }
}

