/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.directeffectsize;

import effectsizeplot.api.AEffectSizeEditorPanel;
import effectsizeplot.input.directeffectsize.DirectESSourceBean;
import effectsizeplot.input.directeffectsize.DirectESSourceBeanExtended;
import effectsizeplot.input.directeffectsize.DirectEffectSizeExtendedTable;
import effectsizeplot.input.directeffectsize.DirectEffectSizeExtendedTableModel;
import formattazione.numeri.MyNumberFormatter;
import gui.alerts.GuiAlerts;
import internovi.numbers.locale.provider.LocaleNumbersProvider;
import internovi.statisticaloptions.provider.StatisticalOptionProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DirectESExtendedPanel
extends AEffectSizeEditorPanel
implements TableModelListener {
    DirectESSourceBeanExtended bean;
    private final MyNumberFormatter myNumberFormatter;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    public JComboBox nullEffectSizeValue;
    public JComboBox scalaDaUsare;
    private JPanel specifyValuePanel;
    public JPanel tabella;
    private JTextField zeroValueInputField;

    public DirectESExtendedPanel(final DirectESSourceBeanExtended bean) {
        this.initComponents();
        this.bean = bean;
        this.myNumberFormatter = new MyNumberFormatter(LocaleNumbersProvider.getLocale(), LocaleNumbersProvider.isGroupSeparatorDisplayed(), StatisticalOptionProvider.getRoundingMode());
        this.scalaDaUsare.removeAllItems();
        this.scalaDaUsare.addItem(NbBundle.getMessage(DirectESSourceBean.class, (String)"scale.linear.name"));
        this.scalaDaUsare.addItem(NbBundle.getMessage(DirectESSourceBean.class, (String)"scale.log.name"));
        this.scalaDaUsare.addItem(NbBundle.getMessage(DirectESSourceBean.class, (String)"scale.fisher.name"));
        if (bean.getTipoDiScala() != null) {
            this.scalaDaUsare.setSelectedItem(bean.getTipoDiScala());
        }
        this.scalaDaUsare.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                bean.setTipoDiScala(DirectESExtendedPanel.this.scalaDaUsare.getSelectedItem().toString());
                DirectESExtendedPanel.this.setModifyTime(new Date().getTime());
            }
        });
        this.nullEffectSizeValue.removeAllItems();
        this.nullEffectSizeValue.addItem("0");
        this.nullEffectSizeValue.addItem("1");
        this.nullEffectSizeValue.addItem(NbBundle.getMessage(DirectESSourceBean.class, (String)"label.specify.newZerovalue"));
        if (!this.myNumberFormatter.formatDouble(Double.valueOf(bean.getZeroValue()), 12).equals(this.myNumberFormatter.formatDouble(Double.valueOf(0.0), 12)) && !this.myNumberFormatter.formatDouble(Double.valueOf(bean.getZeroValue()), 12).equals(this.myNumberFormatter.formatDouble(Double.valueOf(1.0), 12))) {
            this.specifyValuePanel.setVisible(true);
            this.nullEffectSizeValue.setSelectedItem(NbBundle.getMessage(DirectESSourceBean.class, (String)"label.specify.newZerovalue"));
            this.zeroValueInputField.setText(this.myNumberFormatter.formatInLang(bean.getZeroValue()));
        } else {
            this.nullEffectSizeValue.setSelectedItem("" + Math.round(bean.getZeroValue()));
            this.specifyValuePanel.setVisible(false);
        }
        this.nullEffectSizeValue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                NumberFormat numberFormat = DirectESExtendedPanel.this.myNumberFormatter.getNumberFormat(12);
                if (DirectESExtendedPanel.this.nullEffectSizeValue.getSelectedItem().toString().equals(NbBundle.getMessage(DirectESSourceBean.class, (String)"label.specify.newZerovalue"))) {
                    DirectESExtendedPanel.this.specifyValuePanel.setVisible(true);
                } else {
                    DirectESExtendedPanel.this.specifyValuePanel.setVisible(false);
                    try {
                        Number parse2 = numberFormat.parse(DirectESExtendedPanel.this.nullEffectSizeValue.getSelectedItem().toString());
                        bean.setZeroValue(Math.round(parse2.doubleValue()));
                    }
                    catch (ParseException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                DirectESExtendedPanel.this.setModifyTime(new Date().getTime());
            }
        });
        DirectEffectSizeExtendedTable table = new DirectEffectSizeExtendedTable(new DirectEffectSizeExtendedTableModel(bean));
        JPanel tmp = new JPanel(new BorderLayout());
        tmp.add((Component)table.getTableHeader(), "North");
        tmp.add((Component)((Object)table), "Center");
        this.tabella.add(new JScrollPane((Component)((Object)table)));
        table.getModel().addTableModelListener(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.scalaDaUsare = new JComboBox();
        this.jLabel1 = new JLabel();
        this.tabella = new JPanel();
        this.jLabel2 = new JLabel();
        this.nullEffectSizeValue = new JComboBox();
        this.specifyValuePanel = new JPanel();
        this.jButton1 = new JButton();
        this.zeroValueInputField = new JTextField();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.scalaDaUsare.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DirectESExtendedPanel.class, (String)"DirectESExtendedPanel.jLabel1.text"));
        this.tabella.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DirectESExtendedPanel.class, (String)"DirectESExtendedPanel.jLabel2.text"));
        this.nullEffectSizeValue.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.specifyValuePanel.setBackground(Color.white);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(DirectESExtendedPanel.class, (String)"DirectESExtendedPanel.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DirectESExtendedPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.zeroValueInputField.setHorizontalAlignment(4);
        this.zeroValueInputField.setText(NbBundle.getMessage(DirectESExtendedPanel.class, (String)"DirectESExtendedPanel.zeroValueInputField.text"));
        GroupLayout specifyValuePanelLayout = new GroupLayout(this.specifyValuePanel);
        this.specifyValuePanel.setLayout(specifyValuePanelLayout);
        specifyValuePanelLayout.setHorizontalGroup(specifyValuePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(specifyValuePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.zeroValueInputField, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 51, -2).addContainerGap(-1, Short.MAX_VALUE)));
        specifyValuePanelLayout.setVerticalGroup(specifyValuePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, specifyValuePanelLayout.createSequentialGroup().addGroup(specifyValuePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.zeroValueInputField, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scalaDaUsare, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nullEffectSizeValue, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.specifyValuePanel, -2, -1, -2).addGap(0, 69, Short.MAX_VALUE)).addComponent(this.tabella, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scalaDaUsare).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.nullEffectSizeValue)).addComponent(this.specifyValuePanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tabella, -1, 252, Short.MAX_VALUE).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            Number parse = this.myNumberFormatter.getNumberFormat(15).parse(this.zeroValueInputField.getText());
            this.bean.setZeroValue(parse.doubleValue());
            this.zeroValueInputField.setText(this.myNumberFormatter.getNumberFormat(12).format(this.bean.getZeroValue()));
            GuiAlerts.whatAMessage((String)NbBundle.getMessage(DirectESSourceBean.class, (String)"zerovalue.setted"));
        }
        catch (ParseException ex) {
            GuiAlerts.whatAnError((String)NbBundle.getMessage(DirectESSourceBean.class, (String)"error.zerovalue.parse"));
            this.zeroValueInputField.setText(this.myNumberFormatter.formatInLang(this.bean.getZeroValue()));
        }
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        this.setModifyTime(new Date().getTime());
    }
}

