/*
 * Decompiled with CFR 0.152.
 */
package effectsizeplot.input.directeffectsize;

import formattazione.numeri.MyNumberFormatter;
import java.io.Serializable;

public class DirectESRow
implements Serializable {
    private String name = null;
    private Double effectSize = null;
    private Double lowerLimit = null;
    private Double upperLimit = null;
    private Integer sampleSize = null;
    private Integer n1 = null;
    private Integer n2 = null;

    public DirectESRow() {
    }

    public DirectESRow(String name, Double effectSize, Double lowerLimit, Double upperLimit, Integer sampleSize, Integer n1, Integer n2) {
        this.name = name;
        this.effectSize = effectSize;
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.sampleSize = sampleSize;
        this.n1 = n1;
        this.n2 = n2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getEffectSize() {
        return this.effectSize;
    }

    public void setEffectSize(Double effectSize) {
        this.effectSize = effectSize;
    }

    public Double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(Double lowerLimit) {
        this.lowerLimit = lowerLimit;
    }

    public Double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(Double upperLimit) {
        this.upperLimit = upperLimit;
    }

    public Integer getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(Integer sampleSize) {
        this.sampleSize = sampleSize;
    }

    public Integer getN1() {
        return this.n1;
    }

    public void setN1(Integer n1) {
        this.n1 = n1;
    }

    public Integer getN2() {
        return this.n2;
    }

    public void setN2(Integer n2) {
        this.n2 = n2;
    }

    public static DirectESRow createFromText(String text, MyNumberFormatter myNumberFormatter) {
        DirectESRow row = new DirectESRow();
        String[] campi = text.split("\t");
        for (int i = 0; i < campi.length; ++i) {
            if (i == 0) {
                row.setName(campi[i]);
            }
            if (i == 1) {
                try {
                    row.setEffectSize(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 2) {
                try {
                    row.setLowerLimit(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 3) {
                try {
                    row.setUpperLimit(myNumberFormatter.getNumberFormat(14).parse(campi[i]).doubleValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 4) {
                try {
                    row.setSampleSize(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i == 5) {
                try {
                    row.setN1(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (i != 6) continue;
            try {
                row.setN2(myNumberFormatter.getNumberFormat(14).parse(campi[i]).intValue());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return row;
    }

    public String toText(MyNumberFormatter myNumberFormatter) {
        String c = (this.name == null ? "" : this.name) + "\t" + (this.effectSize == null ? "" : myNumberFormatter.formatInLang(this.effectSize.doubleValue())) + "\t" + (this.lowerLimit == null ? "" : myNumberFormatter.formatInLang(this.lowerLimit.doubleValue())) + "\t" + (this.upperLimit == null ? "" : myNumberFormatter.formatInLang(this.upperLimit.doubleValue())) + "\t" + (this.sampleSize == null ? "" : myNumberFormatter.formatInLang(this.sampleSize.intValue())) + "\t" + (this.n1 == null ? "" : myNumberFormatter.formatInLang(this.n1.intValue())) + "\t" + (this.n2 == null ? "" : myNumberFormatter.formatInLang(this.n2.intValue()));
        return c;
    }

    public boolean isVoid() {
        return this.name == null && this.effectSize == null && this.lowerLimit == null && this.upperLimit == null && this.sampleSize == null && this.n1 == null && this.n2 == null;
    }
}

